<?php
/**
 * MidnightStreamer EPG API Proxy
 * Proxies EPG requests using master credentials via XC player_api.php
 *
 * Routes:
 * - /api/player/{user}/{pass}/epg/short/{stream_id}
 * - /api/player/{user}/{pass}/epg/full/{stream_id}
 * - /api/player/{user}/{pass}/epg/full/all
 */

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

$username = $_GET['username'] ?? '';
$password = $_GET['password'] ?? '';
$type = $_GET['type'] ?? 'short';
$stream_id = $_GET['stream_id'] ?? '';
$offset = $_GET['offset'] ?? '';
$limit = $_GET['limit'] ?? '4';
$page = $_GET['page'] ?? '';

// Load config
require_once dirname(dirname(__DIR__)) . '/includes/Config.php';

try {
    $pdo = new PDO(
        "mysql:host={$config['db']['hostname']};dbname={$config['db']['database']};charset=utf8",
        $config['db']['username'],
        $config['db']['password']
    );

    // Get panel settings (master credentials)
    $stmt = $pdo->query("SELECT setting_key, setting_value FROM panel_settings");
    $settings = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $settings[$row['setting_key']] = $row['setting_value'];
    }

    $panel_url = rtrim($settings['panel_url'] ?? '', '/');
    $source_user = $settings['panel_username'] ?? '';
    $source_pass = $settings['panel_password'] ?? '';

    // Use XC player_api.php format which works better
    if ($type === 'full_all') {
        // Full EPG for all channels - use get_simple_data_table without stream_id
        $epg_url = "{$panel_url}/player_api.php?username={$source_user}&password={$source_pass}&action=get_simple_data_table";
    } elseif ($type === 'full') {
        // Full EPG for specific stream
        $epg_url = "{$panel_url}/player_api.php?username={$source_user}&password={$source_pass}&action=get_simple_data_table&stream_id={$stream_id}";
    } else {
        // Short EPG
        $epg_url = "{$panel_url}/player_api.php?username={$source_user}&password={$source_pass}&action=get_short_epg&stream_id={$stream_id}&limit={$limit}";
    }

    // Fetch EPG from source
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $epg_url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_FOLLOWLOCATION => true
    ]);

    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($http_code == 200 && $response) {
        $data = json_decode($response, true);

        // Transform XC format to MidnightStreamer format
        if (isset($data['epg_listings']) && is_array($data['epg_listings'])) {
            $result = [];
            foreach ($data['epg_listings'] as $epg) {
                $result[] = [
                    'stream_id' => $stream_id,
                    'title' => $epg['title'] ?? '',
                    'sub_title' => '',
                    'description' => $epg['description'] ?? '',
                    'start' => $epg['start_timestamp'] ?? '',
                    'end' => $epg['stop_timestamp'] ?? '',
                    'mark_archive' => ($epg['has_archive'] ?? 0) == 1
                ];
            }
            echo json_encode($result);
        } else {
            echo json_encode([]);
        }
    } else {
        echo json_encode([]);
    }

} catch (Exception $e) {
    echo json_encode([]);
}
?>
