<?php 
class Categories_AppAdmin
{
    public $appname = null;
    public $base = null;
    public $img_path = null;
    public $error = '';
    public $array_category_type = [
        'live' => 'live', 
        'movie' => 'movie', 
        'series' => 'series'
    ];
    public function __construct($appname, $base, $img_path = '')
    {
        global $intro;
        $this->admin = $intro->auth->sess_admin();
        if( !in_array($this->admin['level'], [
            1, 
            9
        ]) ) 
        {
            exit( '<h3>Error: you don\'t have permisions to access this file.</h3>' );
        }
        $this->appname = $appname;
        $this->base = $base;
        $this->img_path = $img_path;
        $category_type = trim($intro->input->get_post('category_type'));
        $this->category_type = ($category_type == '' ? 'live' : $category_type);
    }
    public function error($index = '')
    {
        global $error;
        return (isset($error[$index]) ? $error[$index] : '');
    }
    public function nav()
    {
        global $intro;
        global $sess_admin;
        echo policy($sess_admin['adminid'], $this->appname . '.php');
        $sql3 = $intro->db->query('SELECT id from stream_categories where category_type=\'live\' AND parent_id=0;');
        $tot_live = $intro->db->returned_rows;
        $sql4 = $intro->db->query('SELECT id from stream_categories where category_type=\'movie\' AND parent_id=0;');
        $tot_movie = $intro->db->returned_rows;
        $sql5 = $intro->db->query('SELECT id from stream_categories where category_type=\'series\' AND parent_id=0;');
        $tot_series = $intro->db->returned_rows;
        $sql5 = $intro->db->query('SELECT id from stream_categories where parent_id > 0 AND parent_id NOT IN (SELECT id from stream_categories);');
        $tot_parent_not_found = $intro->db->returned_rows;
        $sql5 = $intro->db->query('SELECT id from stream_categories where id=parent_id;');
        $tot_parent_same_id = $intro->db->returned_rows;
        echo "<div class=\"app_nav\">\r\n\t\t\r\n\t\t\t<a class=\"btn btn-success\" href=\"" . $this->base . '/index?category_type=live"><icon class="icon-list"> Live Categories (' . $tot_live . ")</icon></a> \r\n\t\t\t<a class=\"btn btn-warning\" href=\"" . $this->base . '/index?category_type=movie"><icon class="icon-list"> Movie Categories (' . $tot_movie . ")</icon></a> \r\n\t\t\t<a class=\"btn btn-warning\" href=\"" . $this->base . '/index?category_type=series"><icon class="icon-list"> Series Categories (' . $tot_series . ")</icon></a> \r\n\t\t\r\n\t\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('Form') . (' p_add" href="' . $this->base . '/Form?t=add&amp;category_type=' . $this->category_type . '"><icon class="icon-plus-squared"> ') . $intro->lang['stream_categories_add'] . "</icon></a>  \t\t \t\t \r\n\t\t\t\t";
        if( $tot_parent_not_found > 0 ) 
        {
            echo '<a class="btn btn-danger btn-lg" href="' . $this->base . '/index?fix=1"><icon class="icon-list"> Error: Categories that parents Are Deleted (' . $tot_parent_not_found . ' ).</icon></a>';
        }
        if( $tot_parent_same_id > 0 ) 
        {
            echo '<a class="btn btn-danger btn-lg" href="' . $this->base . '/index?fix=2"><icon class="icon-list"> Error: Parent ID = Category ID (' . $tot_parent_same_id . ' ).</icon></a>';
        }
        echo "\r\n\t\t</div>";
    }
    public function index()
    {
        global $intro;
        global $array;
        global $options;
        $qry = '';
        $parent_id = intval($intro->input->get_post('parent_id'));
        $fix = intval($intro->input->get_post('fix'));
        $page = intval($intro->input->get_post('page'));
        $order = trim($intro->input->get_post('order'));
        $search_txt = trim($intro->input->get_post('search_txt'));
        $category_type = trim($intro->db->escape($intro->input->get_post('category_type')));
        $category_type = ($category_type == '' ? 'live' : $category_type);
        $params = '&category_type=' . $category_type;
        $this->nav();
        $cat_type_txt = [
            'live' => 'Streams', 
            'movie' => 'Movies', 
            'series' => 'Series'
        ];
        if( $search_txt != '' ) 
        {
            $qry .= (' and category_name  LIKE \'%' . $search_txt . '%\' ');
        }
        if( $parent_id != 0 ) 
        {
        }
        if( $order == '' ) 
        {
            $order = 'cat_order:asc';
        }
        $order = str_replace(':', ' ', $order);
        $rows_per_page = 200;
        if( $page == 0 ) 
        {
            $page = 1;
        }
        $nexlimit = $page * $rows_per_page - $rows_per_page;
        if( $fix == 1 ) 
        {
            $result = $intro->db->query('SELECT * from stream_categories where parent_id > 0 AND parent_id NOT IN (SELECT id from stream_categories);');
        }
        else if( $fix == 2 ) 
        {
            $result = $intro->db->query('SELECT * from stream_categories where id=parent_id;');
        }
        else
        {
            $result = $intro->db->query('SELECT * ,(SELECT count(id) FROM stream_categories where parent_id=cat.id) as tot_child  ,(SELECT count(id) FROM streams where category_id=cat.id) as tot_streams  ,(SELECT count(id) FROM series where category_id=cat.id) as tot_series ' . (' FROM `stream_categories` cat where cat.parent_id=' . $parent_id . ' AND cat.category_type=\'' . $category_type . '\' ' . $qry . ' order by ' . $order . '  limit ' . $nexlimit . ',' . $rows_per_page));
            $totrows = $intro->db->returned_rows;
            $sql_all_rows = $intro->db->query('SELECT id from stream_categories where parent_id=0 AND category_type=\'' . $category_type . '\' ' . $qry . ' ');
        }
        $totalrows = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22(' [ ' . $category_type . ' ] ' . $intro->lang['stream_categories_cur'] . (' (' . $totalrows . ')'), ($category_type == 'live' ? 'success' : 'warning'));
        echo "\r\n\t\t\r\n\t\t<form action=\"\" method=\"post\">\r\n\t\t" . $intro->lang['search_form'] . (': <input type="text" name="search_txt" value="' . $search_txt . "\" size=\"10\">\r\n\t\t<input type=\"hidden\" name=\"maa\" value=\"Main\">\r\n\t\t<input name=\"name\" value=\"") . $intro->lang['search'] . "\" type=\"submit\">\r\n\t\t</form>\r\n\t\t<!--<div class='pull-right'>Categories Icon Must be: width=214px height=118px</div>-->\r\n\t\t<table class=\"DataTable table-striped table-bordered\" id=\"table-1\">\r\n        <thead>\r\n\t    <tr>\r\n\t\t\t\r\n\t\t\t<th>ID " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('id', 'index') . "</th>\r\n\t\t\t<th>" . $intro->lang['stream_categories_category_type'] . ' ' . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('category_type', 'index', $params) . " </th>\r\n\t\t\t<th>" . $intro->lang['stream_categories_category_name'] . ' ' . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('category_name', 'index', $params) . " </th>\r\n\t\t\t<th>Child Cat. " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('tot_child', 'index', $params) . ' </th>';
        if( isset($options['opt_cat_for']) && $options['opt_cat_for'] == 'yes' ) 
        {
            echo '<th>For ' . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('cat_for', 'index', $params) . '</th>';
        }
        echo "\r\n\t\t\t<th>" . $intro->lang['stream_categories_view_order'] . ' ' . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('cat_order', 'index', $params) . " </th>\r\n\t\t\t<th>" . $intro->lang['stream_categories_category_icon'] . ' ' . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('category_icon', 'index', $params) . " </th>\r\n\t\t\t<th>" . $cat_type_txt[$category_type] . "</th>\r\n\t\t\t<th>" . $intro->lang['options'] . "</th>\r\n\t    </tr>\r\n\t\t</thead>\r\n\t\t\r\n\t\t<tbody>";
        $i = $tot_child = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            echo "\r\n\t\t\t<tr id=\"" . $id . '" class="' . _obf_0D0E3B292A301E3D17315C402B08361326052C04400E22($i) . ("\">\r\n\t\t\t\t\r\n\t\t\t\t<td class=\"dragHandle center\">" . $id . "</td>\r\n\t\t\t\t<td class='center'><span class=\"label label-") . (($category_type == 'live' ? 'success' : 'warning')) . ('">' . $category_type . "</span> </td>\r\n\t\t\t\t<td class=\"dragHandle\">") . $this->get_parent($parent_id) . (' ' . $category_name . "</td>\r\n\t\t\t\t<td class=\"center\">") . (($tot_child > 0 ? '<a class=\'btn btn-default\' href="' . $this->base . '/index?category_type=' . $category_type . '&parent_id=' . $id . '">Manage Child (' . $tot_child . ')</a>' : '')) . '</td>';
            if( isset($options['opt_cat_for']) && $options['opt_cat_for'] == 'yes' ) 
            {
                echo '<td>' . $array['cat_for'][$cat_for] . '</td>';
            }
            echo "\r\n\t\t\t\t\r\n\t\t\t\t<td class='center'>" . $cat_order . "</td>\r\n\t\t\t\t\r\n\t\t\t\t<td class='center'><img src=\"" . $category_icon . '" width=\'50\' height=\'50\' alt=\'\' /></td>';
            if( $category_type == 'movie' ) 
            {
                echo '<td class=\'center\'><a class="btn btn-default" href="' . $intro->app_url('movies', 'index') . ('?category_id=' . $id . '">' . $tot_streams . '</a></td>');
            }
            else if( $category_type == 'series' ) 
            {
                echo '<td class=\'center\'><a class="btn btn-default" href="' . $intro->app_url('series', 'index') . ('?category_id_s=' . $id . '">' . $tot_series . '</a></td>');
            }
            else
            {
                echo '<td class=\'center\'><a class="btn btn-default" href="' . $intro->app_url('streams', 'index') . '?category_id=' . $id . '">' . $tot_streams . '</a></td>';
            }
            echo "\r\n\t\t\t\t<td class=\"center\"> \r\n\t\t\t\t\t<a class=\"btn btn-info p_edit\" href=\"" . $this->base . '/Form?t=edit&amp;id=' . $id . '&amp;category_type=' . $category_type . '" title="' . $intro->lang['edit'] . ("\"><i class=\"icon-edit\"></i></a>\r\n\t\t\t\t\t<a class=\"btn btn-danger p_del intro_ui_del\" href=\"" . $this->base . '/Del?id=' . $id . '&amp;category_type=' . $category_type . '" OnClick="return false;" title="') . $intro->lang['del'] . "\"><i class=\"icon-trash\"></i></a>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>";
        }
        echo "</tbody>\r\n\t\t\t</table>";
        $order = str_replace(' ', ':', $order);
        echo '<center>' . _obf_0D310332094006251F2A1D300709060C1C245B0E110B32($this->base . '/index?search_txt=' . $search_txt . '&amp;order=' . $order . '&category_type=' . $category_type, $totalrows, $rows_per_page, $page) . '</center>';
        echo "<div class=center>\r\n\t\t\t<a href=\"" . $this->base . '/FixOrder?category_type=' . $category_type . "\">Fix View Order</a>\r\n\t\t\t<div id=\"AjaxResult\"></div>\r\n\t\t</div>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo "\t\t<script>\r\n\t\t\$('#table-1').tableDnD({\r\n            hierarchyLevel: 4,\r\n            onDragStart: function(table, row) {\r\n                \$('#AjaxResult').html('');\r\n            },\r\n            onDrop: function(table, row) {\r\n\t\t\t\t\$('#AjaxResult').load(\"";
        echo $this->base;
        echo '/doSort?category_type=';
        echo $category_type;
        echo "&NH=1&\"+\$.tableDnD.serialize());\r\n            }\r\n        });\r\n\t\t</script>\r\n\t\t";
    }
    public function doSort()
    {
        global $intro;
        $data_id = '';
        $menu = $_GET['table-1'];
        for( $i = 0; $i < count($menu); $i++ ) 
        {
            $id = intval($menu[$i]);
            $a = $i + 1;
            $intro->db->query('UPDATE stream_categories SET cat_order=' . $a . ' WHERE id=' . $id . ' ');
        }
        echo ' :: Order Done:: ' . $data_id;
    }
    public function FixOrder()
    {
        global $intro;
        $category_type = trim($intro->input->get('category_type'));
        $sql = $intro->db->query('select id from stream_categories where category_type=\'' . $category_type . '\' order by cat_order ASC');
        $w1 = 0;
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            $w1++;
            $id = intval($row['id']);
            $intro->db->query('UPDATE stream_categories SET cat_order=' . $w1 . ' WHERE id=' . $id . ' ');
        }
        $intro->redirect($this->appname, 'index', '?category_type=' . $category_type);
    }
    public function Form($t = '')
    {
        global $intro;
        global $error;
        global $sess_admin;
        global $array;
        global $options;
        global $category_type;
        global $category_name;
        global $cat_order;
        global $parent_id;
        global $category_icon;
        global $data_type;
        global $series_plot;
        global $series_cast;
        global $series_rate;
        global $series_year;
        global $data_parent;
        global $series_type;
        global $cat_for;
        if( $error || $_POST != null ) 
        {
            @extract($_POST);
        }
        $IF = intval($intro->input->get_post('IF'));
        $id = intval($intro->input->get_post('id'));
        $t = ($t == '' ? $intro->input->get_post('t') : $t);
        if( $IF != 1 ) 
        {
            $this->nav();
        }
        $icon = '';
        if( $t == 'edit' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'edit');
            $sql = $intro->db->query('SELECT * FROM stream_categories where id=\'' . $id . '\'');
            $row = $intro->db->fetch_assoc($sql);
            @extract($row);
            $icon = '<img src="' . $category_icon . '" style="max-height:100px;float:right;position:absolute;right:0;top:-50px;">';
            $btn['legend_name'] = $intro->lang['stream_categories_edit'] . (' <b>' . $id . '</b>');
            $btn['legend_icon'] = 'icon-edit';
            $btn['name'] = 'Save Changes';
            $btn['img_icon'] = 'icon-floppy';
            $btn['action'] = 'doEdit';
            $btn['copy'] = ' ';
        }
        else if( $t == 'add' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'add');
            $btn['legend_name'] = $intro->lang['stream_categories_add'];
            $btn['legend_icon'] = 'icon-plus-squared';
            $btn['name'] = 'Save';
            $btn['img_icon'] = 'icon-plus-squared';
            $btn['action'] = 'doAdd';
            $btn['copy'] = '';
            $category_type = ($category_type == '' ? $intro->input->get_post('category_type') : $category_type);
        }
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="' . $btn['legend_icon'] . '"></i> ' . $btn['legend_name'] . ' ', 'info');
        echo $this->error . "\r\n\t\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . '/' . $btn['action'] . "\" enctype=\"multipart/form-data\">\r\n\t\t\t<table class=\"DataTable table-striped table-bordered table-condensed\" id=\"table_codes\">\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Stream Type :  <span style='color:#ff0000'>*</span></td>\r\n\t\t\t\t<td>" . _obf_0D3114132D0E1B5C14292309230C3F01222903383B2811('category_type', $this->array_category_type, $category_type, $txt = '') . (' ' . $this->error('category_type') . "</td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td>") . $intro->lang['stream_categories_parent'] . " : </td>\r\n\t\t\t\t<td>" . $this->form_parent($parent_id, $category_type) . ($this->error('parent_id') . "</td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td>") . $intro->lang['stream_categories_category_name'] . (" :  <span style='color:#ff0000'>*</span></td>\r\n\t\t\t\t<td><input class='form-control' type=\"text\" name=\"category_name\" value=\"" . $category_name . '"> ' . $this->error('category_name') . "</td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td>") . $intro->lang['stream_categories_view_order'] . (" : </td>\r\n\t\t\t\t<td><input  type=\"text\" name=\"cat_order\" value=\"" . $cat_order . '" size="5"> ' . $this->error('cat_order') . "</td>\r\n\t\t\t</tr>\r\n\t\t\t\r\n\t\t\t<tr>\r\n\t\t\t\t<td>") . $intro->lang['stream_categories_category_icon'] . (" : </td>\r\n\t\t\t\t<td style=\"position:relative;\"><input class='form-control' type=\"text\" name=\"category_icon\" value=\"" . $category_icon . '"> ' . $this->error('category_icon') . ' ' . $icon . "</td>\r\n\t\t\t</tr>");
        if( isset($options['opt_cat_for']) && $options['opt_cat_for'] == 'yes' ) 
        {
            echo "\r\n\t\t\t\t<tr>\r\n\t\t\t\t\t<td>For : </td>\r\n\t\t\t\t\t<td>" . _obf_0D1029270D2B062E351F39253F1B39061037400E130401('cat_for', $array['cat_for'], $cat_for, '', 0) . (' ' . $this->error('cat_for') . "</td>\r\n\t\t\t\t</tr>");
        }
        echo "<tr>\r\n\t\t\t\t<td class=\"center\" colspan=\"2\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"app_name\"  value=\"" . $this->appname . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"t\"  value=\"" . $t . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"id\"  value=\"" . $id . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"IF\"  value=\"" . $IF . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"get_category_type\"  value=\"" . trim($intro->input->get_post('category_type')) . ("\">\r\n\t\t\t\t\t<button class=\"btn btn-success\" type=\"submit\" name=\"app_action\" value=\"" . $btn['action'] . "\">\r\n\t\t\t\t\t<i class=\"" . $btn['img_icon'] . '"></i> ' . $btn['name'] . " </button>\r\n\t\t\t\t\t\r\n\t\t\t\t</td>\r\n\t\t\t</tr>\r\n\t\t\t</table>\r\n\t\t\t</form>");
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo "\r\n\t\t<script>\r\n\t\t\r\n\t\t\$(document).ready(function () {\r\n\r\n\t\t\t\$(\"#data_type\").change(function(){\r\n\t\t\t\tvar val = \$(this).val();\r\n\t\t\t});\r\n\t\t});\r\n\t\t</script>";
    }
    public function form_parent($comp = 0, $category_type)
    {
        global $intro;
        global $error;
        $qry = '';
        $category_type = trim($intro->input->get_post('category_type'));
        if( $category_type != '' ) 
        {
            $qry = ' AND category_type=\'' . $category_type . '\' ';
        }
        $id = intval($intro->input->get_post('id'));
        if( $id != 0 ) 
        {
            $qry .= (' AND id!=' . $id . ' ');
        }
        $result = $intro->db->query('SELECT * from stream_categories where ' . (' parent_id=0 ' . $qry . ' order by category_name asc;'));
        $html = "<select name='parent_id' id='parent_id'>\r\n\t\t<option value=\"0\"> No Parent </option>";
        $i = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            $html .= ('<option value="' . $id . '" ' . (($id == $comp ? 'selected="selected"' : '')) . ('>[' . $category_type . '] ' . $category_name . ' </option>'));
        }
        $html .= '</select>';
        return $html;
    }
    public function get_parent($id = 0)
    {
        global $intro;
        global $error;
        $category_name = '';
        $result = $intro->db->query('SELECT * from stream_categories where id=' . $id . ';');
        $myrow = $intro->db->fetch_assoc($result);
        @extract($myrow);
        return ($myrow['category_name'] != '' ? $myrow['category_name'] . ' > ' : '');
    }
    public function doAdd()
    {
        global $intro;
        global $error;
        global $options;
        $get_category_type = trim($intro->input->post('get_category_type'));
        $category_type = trim($intro->input->post('category_type'));
        $category_name = trim($intro->input->post('category_name'));
        $cat_order = intval($intro->input->post('cat_order'));
        $parent_id = intval($intro->input->post('parent_id'));
        if( $category_type == '' || $category_name == '' ) 
        {
            if( $category_type == '' ) 
            {
                $error['category_type'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $category_name == '' ) 
            {
                $error['category_name'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            $this->Form('add');
            exit();
        }
        $data = [];
        $data['category_type'] = $intro->input->post('category_type');
        $data['category_name'] = $intro->input->post('category_name');
        $data['cat_order'] = $intro->input->post('cat_order');
        $data['parent_id'] = $intro->input->post('parent_id');
        $data['category_icon'] = $intro->input->post('category_icon');
        if( isset($options['opt_cat_for']) && $options['opt_cat_for'] == 'yes' ) 
        {
            $data['cat_for'] = intval($intro->input->post('cat_for'));
        }
        $intro->db->insert('stream_categories', $data);
        $id = intval($intro->db->insert_id());
        if( $id == 0 ) 
        {
            exit( '<h1>Error adding category . Zero value. error in database.</h1>' );
        }
        $intro->redirect($this->appname, 'index', '?category_type=' . $get_category_type);
    }
    public function doEdit()
    {
        global $intro;
        global $array;
        global $options;
        $get_category_type = trim($intro->input->post('get_category_type'));
        $data_type = intval($intro->input->post('data_type'));
        $series_type = trim($intro->input->post('series_type'));
        $data = [];
        $data['category_type'] = $intro->input->post('category_type');
        $data['category_name'] = $intro->input->post('category_name');
        $data['cat_order'] = $intro->input->post('cat_order');
        $data['parent_id'] = intval($intro->input->post('parent_id'));
        $data['category_icon'] = $intro->input->post('category_icon');
        if( isset($options['opt_cat_for']) && $options['opt_cat_for'] == 'yes' ) 
        {
            $data['cat_for'] = intval($intro->input->post('cat_for'));
        }
        $id = intval($intro->input->post('id'));
        if( intval($intro->input->post('id')) == intval($intro->input->post('parent_id')) ) 
        {
            $this->error = _obf_0D3D40321528110F062A0B0321102712170C15030F2232('error: category cannot be parent of itself.', 'danger');
            $this->Form('edit');
            exit();
        }
        $intro->db->update('stream_categories', $data, 'id=' . $id);
        $intro->redirect($this->appname, 'index', '?category_type=' . $get_category_type);
    }
    public function Del()
    {
        global $intro;
        global $sess_admin;
        global $array;
        $id = intval($intro->input->get_post('id'));
        policy($sess_admin['adminid'], $this->appname . '.php', 'del');
        $sql = $intro->db->query('DELETE FROM stream_categories WHERE id=' . $id . ' ');
        $intro->redirect($this->appname);
    }
    public function ViewSeries()
    {
        global $intro;
        global $array;
        $category_id = trim($intro->input->get_post('category_id'));
        $this->nav();
        $result = $intro->db->query('SELECT * from series where category_id=' . $category_id . ' order by id asc;');
        $totalrows = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22(' Series for category id (' . $category_id . ') (' . $totalrows . ')', 'info');
        echo "\r\n\t\t<table class=\"table table-hover table-striped table-bordered\">\r\n        <thead>\r\n\t    <tr>\r\n\t\t\t\r\n\t\t\t<th>ID " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('id', 'index') . "</th>\r\n\t\t\t<th>Title " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('title', 'index') . "</th>\r\n\t\t\t<th>Cover</th>\r\n\t\t\t\r\n\t    </tr>\r\n\t\t</thead>\r\n\t\t\r\n\t\t<tbody>";
        $i = $tot_child = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t\r\n\t\t\t\t<td class=\"center\">" . $id . "</td>\r\n\t\t\t\t<td class=\"\">" . $title . "</td>\r\n\t\t\t\t<td class=\"center\"><img src=\"" . $cover . "\" width='50' height='50' alt='' /></td>\r\n\t\t\t\t\r\n\t\t\t</tr>";
        }
        echo "</tbody>\r\n\t\t\t</table>";
    }
}
