<?php 
class Codes_import_AppAdmin
{
    public $appname = null;
    public $base = null;
    public $img_path = null;
    public function __construct($appname, $base, $img_path = '')
    {
        global $intro;
        $this->admin = $intro->auth->sess_admin();
        if( $this->admin['level'] != 1 && $this->admin['level'] != 1 && $this->admin['level'] != 2 ) 
        {
            exit( '<h3>Error: you don\'t have permisions to access this file.</h3>' );
        }
        $this->appname = $appname;
        $this->base = $base;
        $this->img_path = $img_path;
    }
    public function error($index = '')
    {
        global $error;
        return (isset($error[$index]) ? $error[$index] : '');
    }
    public function nav()
    {
        global $intro;
        global $sess_admin;
        global $config;
        echo "<div class=\"app_nav\">\r\n\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('index') . ('" href="' . $this->base . "/index\"><icon class=\"icon-list\"> Import </icon> </a> \r\n\t\t</div>");
    }
    public function index()
    {
        global $intro;
        global $array;
        global $username_prefix;
        global $allcodes;
        global $daysbought;
        global $error;
        global $fullname;
        global $bouquets;
        global $forced_country;
        global $period;
        global $allowed_uagent;
        if( $error || $_POST != null ) 
        {
            @extract($_POST);
        }
        echo "\r\n\t\t<div class=\"forms\">\t\r\n\t\t\t<fieldset>\r\n\t\t\t\t<legend>\r\n\t\t\t\t\t<i class=\"icon-up\"></i> Import Codes\r\n\t\t\t\t</legend><span style='color:red'>\r\n\t\t\tNote: this form will add to database at once. and will ignore duplicated codes. <br/>\r\n\t\t\t </span>\r\n\t\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . "/doAdd\" enctype=\"multipart/form-data\">\r\n\t\t\t<table class=\"table table-bordered\">\r\n\t\t\t\r\n\t\t\t<tr>\r\n\t\t\t\t<td style=\"width:250px\">Paste Codes:</td>\r\n\t\t\t\t<td><textarea style=\"width:100%;height:200px;\" name=\"allcodes\" id=\"allcodes\">" . $allcodes . "</textarea></td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Trans Name :  <span style='color:#ff0000'>*</span></td>\r\n\t\t\t\t<td><input  type=\"text\" name=\"fullname\" value=\"" . $fullname . '" size="30"> ' . $this->error('fullname') . "\r\n\t\t\t\t <span dir=rtl> <br/>\r\n\t\t\t\t  </span></td>\r\n\t\t\t</tr>\r\n\t\t\t<!--\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Username Prefix: <font color=red>*</font> </td>\r\n\t\t\t\t<td><input type=\"text\" name=\"username_prefix\" value=\"" . $username_prefix . '" size="20" maxlength="15" />  ' . $this->error('username_prefix') . "\r\n\t\t\t\t\t<br> username prefix: like dummy , mag250, gold200tn .. etc \r\n\t\t\t\t\t<br>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>-->\r\n\t\t\t<tr>\r\n\t\t\t\t<td>" . $intro->lang['codes_days'] . " :  <span style='color:#ff0000'>*</span></td>\r\n\t\t\t\t<td>" . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('period', _obf_0D322A5B141A102E2824032B03230A35140306272F2F11(), $period) . (' ' . $this->error('period') . "</td>\r\n\t\t\t</tr>\t\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Override General Country Restriction:  </td>\r\n\t\t\t\t<td> ") . forced_country($forced_country) . (" </td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Bouquets:  <span style='color:#ff0000'>*</span></td>\r\n\t\t\t\t<td> " . $this->error('bouquets') . ' ') . bouquets($bouquets) . "</td>\r\n\t\t\t</tr>";
        if( $this->admin['level'] == 1 ) 
        {
            echo "\r\n\t\t\t\t<tr>\r\n\t\t\t\t\t<td>Allowed User Agent :</td>\r\n\t\t\t\t\t<td><input  type=\"text\" name=\"allowed_uagent\" value=\"" . $allowed_uagent . '" size="30"> ' . $this->error('allowed_uagent') . " <i>(Allowed User Agents to use this account [Default all allowed])</i></td>\r\n\t\t\t\t</tr>";
        }
        echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td class=\"center\" colspan=\"2\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"app_name\"  value=\"" . $this->appname . "\">\r\n\t\t\t\t\t<button type=\"submit\" name=\"app_action\" value=\"doAdd\"><i class=\"icon-plus-squared\"> Go </i></button>\r\n\t\t\t\t\r\n\t\t\t\t</td>\r\n\t\t\t</tr>\r\n\t\t\t</table>\r\n\t\t\t</form>\r\n\t\t\t</fieldset>\r\n\t\t</div>";
    }
    public function months()
    {
        return "<select name=\"months\" id=\"months\">\r\n\t\t\t\t\t<option value=\"30\" selected=\"selected\">1 month</option>\r\n\t\t\t\t\t<option value=\"90\">3 months</option>\r\n\t\t\t\t\t<option value=\"180\">6 months</option>\r\n\t\t\t\t\t<option value=\"365\">12 months</option>\r\n\t\t\t</select>\r\n\t\t\t<script>\r\n\t\t\t\$(document).ready(function(){\r\n\t\t\t\t\$('#months').change(function(){\r\n\t\t\t\t\t\$('#daysbought').val(\$(this).val());\r\n\t\t\t\t});\r\n\t\t\t\t\r\n\t\t\t});\r\n\t\t\t</script>";
    }
    public function doAdd()
    {
        global $intro;
        global $error;
        global $sess_admin;
        $fullname = trim($intro->input->post('fullname'));
        $username_prefix = trim($intro->input->post('username_prefix'));
        $daysbought = intval($intro->input->post('daysbought'));
        $period = intval($intro->input->post('period'));
        $allcodes = $intro->input->post('allcodes');
        $allcodes = explode("\n", $allcodes);
        $bouquets = $intro->input->post('bouquets');
        $forced_country = trim($intro->input->post('forced_country'));
        $allowed_uagent = trim($intro->input->post('allowed_uagent'));
        $num_start = 1;
        $num = count($allcodes);
        if( $bouquets == null || $fullname == '' || $period == 0 ) 
        {
            if( $bouquets == null ) 
            {
                $error['bouquets'] = '<span class=error>Please choose at least one PACKAGE</span>';
            }
            if( $fullname == '' ) 
            {
                $error['fullname'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $period == 0 ) 
            {
                $error['period'] = '<span class=error>' . $intro->lang['required'] . ' And don\'t use free.</span>';
            }
            $this->index();
            exit();
        }
        $days = $period * 30;
        $totalinvoices = 0;
        if( $this->admin['level'] != 1 ) 
        {
            $adm = $intro->auth->admin_data($this->admin['adminid']);
            $cost = floatval($adm['cost_' . $period]);
            if( $cost <= 0 ) 
            {
                _obf_0D103C08311F24242D2F281F0B3E28333032320A031011('Error: unable to get total cost, please contact system admin.', 'danger');
                $this->Form('add');
                exit();
            }
            $totalinvoices = $cost * $num;
            $adminbalanc = _obf_0D3B1A30163C23381912245B381E2D3F0B0B340C070901($this->admin['adminid']);
            if( $adminbalanc < $totalinvoices ) 
            {
                _obf_0D103C08311F24242D2F281F0B3E28333032320A031011('Insufficient balance ... Please charge your account or contact sysytem admin ', 'danger');
                $this->Form('add');
                exit();
            }
        }
        if( $num > 1 ) 
        {
            $length = strlen($allcodes[0]);
            $intro->db->insert(PREFIX . '_codes_trans', [
                'trans_name' => $fullname, 
                'trans_codes' => $num, 
                'trans_date' => time(), 
                'trans_codes_length' => $length, 
                'adminid' => $this->admin['adminid']
            ]);
            $transid = $intro->db->insert_id();
        }
        else
        {
            $transid = 0;
        }
        $daysbought = $period * 30;
        $tot = 0;
        for( $i = 0; $i <= $num; $i++ ) 
        {
            $code = (isset($allcodes[$i]) ? trim($allcodes[$i]) : '');
            if( strlen($code) > 5 ) 
            {
                $tot++;
                $data = [];
                $data['fullname'] = $fullname;
                $data['code'] = $code;
                $data['days'] = $daysbought;
                $data['period'] = $period;
                $data['adminid'] = $this->admin['adminid'];
                $data['transid'] = $transid;
                $data['status'] = 0;
                $data['last_update'] = '';
                $data['bouquets'] = implode(',', $bouquets);
                $data['forced_country'] = $forced_country;
                $data['allowed_uagent'] = $allowed_uagent;
                $intro->db->insert(PREFIX . '_codes', $data);
                $num_start++;
            }
        }
        if( $totalinvoices > 0 ) 
        {
            $data2['depit'] = $totalinvoices;
            $data2['amount'] = $totalinvoices;
            $data2['period'] = $period;
            $data2['admin'] = $this->admin['adminid'];
            $data2['userid'] = 0;
            $data2['type'] = 1;
            $data2['dateadded'] = date('Y-m-d H:i:s');
            $data2['Notes'] = 'Import ' . $num . ' codes(s) - ' . $period . ' Month(s)  ';
            $intro->db->insert('solus_trans', $data2);
        }
        $intro->redirect('codes', 'index');
    }
    public function random_number($length)
    {
        $random = substr(number_format(time() * rand(), 0, '', ''), 0, $length);
        return $random;
    }
}
