<?php 
class Firewall_AppAdmin
{
    public $appname = null;
    public $base = null;
    public $img_path = null;
    public $qry_admin = '';
    public $qry_admin_where = '';
    public $admin = [];
    public function __construct($appname, $base, $img_path = '')
    {
        global $intro;
        $this->appname = $appname;
        $this->base = $base;
        $this->img_path = $img_path;
        $this->admin = $intro->auth->sess_admin();
        if( $this->admin['level'] != 1 ) 
        {
            $this->qry_admin = ' and adminid=' . intval($this->admin['adminid']);
            $this->qry_admin_where = ' where adminid=' . intval($this->admin['adminid']);
        }
    }
    public function error($index = '')
    {
        global $error;
        return (isset($error[$index]) ? $error[$index] : '');
    }
    public function nav()
    {
        global $intro;
        global $sess_admin;
        echo policy($sess_admin['adminid'], $this->appname . '.php');
        echo "\n\t\t<div class=\"app_nav\">\n\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('index') . ('" href="' . $this->base . "/index\">\n\t\t\t<icon class=\"icon-list\">Firewall IPs</icon>\n\t\t</a>\n\t\t<a class=\"btn btn-danger\" href=\"" . $this->base . "/Block_by_iptables\" OnClick=\"return confirm('This will block bad IPs using iptables firewall.');\">Block in iptables</a>\n\t\t<a class=\"btn btn-info\" href=\"" . $this->base . "/Export?maa=all\">Export All</a>\n\t\t<a class=\"btn btn-success\" href=\"" . $this->base . "/resetHits\" OnClick=\"return confirm('This will make Hits = 0.');\">Reset Hits</a>\n\t\t<a class=\"btn btn-success\" href=\"" . $this->base . "/unblockall\" OnClick=\"return confirm('Warning: This will clear all blocked IPs!.');\">Clear All</a>\n\t\t<a class=\"btn btn-primary\" href=\"" . $this->base . "/SaveToFile\" OnClick=\"return confirm('This will add bad IPs to ip.txt and block them manually.');\">Block by File</a>\n\t\t</div>\n\t\t\n\t\t<div class=\"app_nav\">\n\t\t\t<a class=\"btn btn-info\" href=\"" . $this->base . "/index?type=1\">View Not Blocked</a> \n\t\t\t<a class=\"btn btn-info\" href=\"" . $this->base . "/index?type=2\">View Blocked</a>\n\t\t</div>");
        if( function_exists('sys_getloadavg') ) 
        {
            $load = sys_getloadavg();
            if( is_array($load) ) 
            {
                echo "<div class=\"app_nav\">\n\t\t\t\t\t<span class='label-default'>CPU Load: </span> ";
                foreach( $load as $key => $val ) 
                {
                    echo '<span class=\'label-info\'>' . $val . '</span> ';
                }
                echo '</div>';
            }
        }
        echo 'Mem: <span class=\'label-success\'> ' . _obf_0D223F350731381A3F101E2F0B0536222129393F132201() . '</span>';
    }
    public function unblockall()
    {
        global $intro;
        global $array;
        $this->nav();
        $result = $intro->db->query('SELECT * from ' . PREFIX . '_ips;');
        $totrows = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Unblock ALL (' . $totrows . ')');
        $intro->db->query('delete from ' . PREFIX . '_ips where hits <= 10;');
        exit( 'Success. all IPs cleared. hits less than 10' );
        $html = '';
        $i = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            $id = intval($id);
            echo '<li>' . $i . ' - ' . $ip . ' = ';
            echo ' unblocked';
            $intro->db->query('delete from ' . PREFIX . ('_ips where id=' . $id));
        }
        echo '<h1>All</h1> ' . $html;
        $result = $intro->db->query('truncate ' . PREFIX . '_ips');
        file_put_contents('ip.txt', '', LOCK_EX);
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function Block_by_iptables()
    {
        global $intro;
        global $array;
        $this->nav();
        if( trim($intro->input->get_post('maa')) == 'all' ) 
        {
            $qry = '';
        }
        else
        {
            $qry = ' type=1 AND ';
        }
        $result = $intro->db->query('SELECT * from ' . PREFIX . ('_ips where ' . $qry . ' hits > 5 order by hits DESC;'));
        $totrows = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Exported to BLOCK (' . $totrows . ')');
        $html = '';
        $i = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            $html .= ('iptables -A INPUT -s ' . $ip . ' -j DROP &&');
            echo shell_exec('iptables -A INPUT -s ' . $ip . ' -j DROP') . ('<li>' . $ip . ' Blocked.');
            $intro->db->query('update ' . PREFIX . ('_ips set type=2 where id=' . $id));
        }
        echo '<h1>All</h1> ' . $html;
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function SaveToFile($echo = '')
    {
        global $intro;
        global $array;
        $this->nav();
        $result = $intro->db->query('SELECT ip from ' . PREFIX . '_ips where type!=3 AND hits > 10 order by hits DESC;');
        $totrows = $intro->db->returned_rows;
        if( $echo == '' ) 
        {
            echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Exported to File (' . $totrows . ')');
        }
        $html = '';
        $i = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            $html .= ($ip . "\n");
        }
        file_put_contents('ip.txt', $html . "\n", LOCK_EX);
        if( $echo == '' ) 
        {
            echo '<h1> ' . $totrows . ' IPs Saved to file <a href=\'../../ip.txt\'>ip.txt</a></h1>';
            echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        }
    }
    public function resetHits()
    {
        global $intro;
        global $array;
        $this->nav();
        $result = $intro->db->query('update ' . PREFIX . '_ips set hits=0');
        echo '<h1>Done!';
    }
    public function index()
    {
        global $intro;
        global $array;
        $this->nav();
        $order = trim($intro->input->get_post('order'));
        $page = trim($intro->input->get_post('page'));
        $ip = trim($intro->input->get_post('ip'));
        if( !isset($order) || $order == '' ) 
        {
            $order = 'adminid_asc';
        }
        $order = str_replace('_desc', ' desc', $order);
        $order = str_replace('_asc', ' asc', $order);
        $rows_per_page = 200;
        if( !isset($page) || $page == '' ) 
        {
            $page = 1;
        }
        $nexlimit = $page * $rows_per_page - $rows_per_page;
        $type = intval($intro->input->get_post('type'));
        $qry = '';
        if( $type != 0 ) 
        {
            $qry = ' WHERE type=' . $type . ' ';
        }
        if( $ip != '' ) 
        {
            $qry = ' WHERE ip=\'' . $ip . '\' ';
        }
        $result = $intro->db->query('SELECT * from ' . PREFIX . ('_ips ' . $qry . ' order by hits DESC limit ' . $nexlimit . ',' . $rows_per_page . ';'));
        $totrows = $intro->db->returned_rows;
        $resultnumm = $intro->db->query('SELECT id from ' . PREFIX . ('_ips ' . $qry));
        $totalrows = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('IPs (' . $totalrows . ')');
        echo "\n\t\t<form action=\"\" method=\"post\" class=''>\n\t\t\t<input type=\"text\" name=\"ip\" value=\"" . $ip . "\" size=\"25\" placeholder=\" IP \">\t\t\t\n\t\t\t<input  name=\"name\" value=\"Search\" type=\"submit\">\n\t\t</form>";
        echo "\n\t\t\n\t\t\n\t\t<table class=\"DataTable table-striped table-bordered table-hover\" id=\"table_codes\">\n        <thead>\n\t    <tr>\n\t\t\n\t\t\t<th>#</th>\n\t\t\t<th> IP </th>\n\t\t\t<th> Hits </th>\n\t\t\t<th> Protocol </th>\n\t\t\t<th> Type </th>\n\t\t\t<th> Options </th>\n\t\t\t<th>  </th>\n\t\t\t\n\t    </tr>\n\t\t</thead>\n\t\t\n\t\t<tbody>";
        $i = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            echo "\n\t\t\t<tr class=\"" . _obf_0D0E3B292A301E3D17315C402B08361326052C04400E22($i) . ("\">\n\t\t\t\t<td class=\"center\">" . $i . "</td>\n\t\t\t\t<td class=\"center\"><a href='http://www.ip-tracker.org/locator/ip-lookup.php?ip=" . $ip . '\' target=\'_blank\'>' . $ip . "</a></td>\n\t\t\t\t<td class=\"center\">" . $hits . "</td>\n\t\t\t\t<td class=\"center\">" . $file . "</td>\n\t\t\t\t<td class=\"center\">" . $type . "</td>\n\t\t\t\t\n\t\t\t\t<td class=\"center\">\n\t\t\t\t\t<a class=\"btn btn-danger btn-xs IpBlock\" id=\"" . $id . '" href="' . $this->base . '/Block?NH=1&id=' . $id . '&ip=' . $ip . "\" OnClick=\"return false;\" title='Block'>B</a>\n\t\t\t\t\t<a class=\"btn btn-info btn-xs IpFind\" id=\"" . $id . '" href="' . $this->base . '/Find?NH=1&id=' . $id . '&ip=' . $ip . "\" OnClick=\"return false;\" title='Find'>F</a>\n\t\t\t\t\t<a class=\"btn btn-success btn-xs UnBlock\" id=\"" . $id . '" href="' . $this->base . '/UnBlock?NH=1&id=' . $id . '&ip=' . $ip . "\" OnClick=\"return false;\" title='Unblock'>U</a>\n\t\t\t\t</td>\n\t\t\t\t<td id='ipResultBlock" . $id . "'></td>\n\t\t\t</tr>");
        }
        echo "</tbody>\n\t\t\t</table>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411('<center>' . _obf_0D310332094006251F2A1D300709060C1C245B0E110B32($this->base . '/index?&order=' . $order, $totalrows, $rows_per_page, $page) . '</center>');
        echo "<script>\n\t\t\$(document).ready(function() {\n\t\t\t\n\t\t\t\n\t\t\t\$('.deldel').click(function(e){\n\t\t\t\te.preventDefaults;\n\t\t\t\t\n\t\t\t\tif(!confirm('Are you sure you want to BlockIP?')) return false;\n\t\t\t\t\n\t\t\t\tvar link_tr = \$(this).closest('tr');\n\t\t\t\t\n\t\t\t\t\$.get( \$(this).attr('href'), function( data ) {\n\t\t\t\t\t\n\t\t\t\t\tlink_tr.fadeOut();\n\t\t\t\t});\n\t\t\t\treturn false;\n\t\t\t});\n\t\t\t\n\t\t\t\$(\".IpBlock,.IpFind\").on(\"click\", function(e) {\n\t\t\t\t\n\t\t\t\te.preventDefault();\n\t\t\t\t\n\t\t\t\tif(!confirm('Are you sure?')) return false;\n\t\t\t\t\n\t\t\t\tvar id = \$(this).attr('id');\n\t\t\t\t\$(\"#ipResultBlock\" + id).html('Loading...');\n\t\t\t\t\$.get( \$(this).attr('href') , function( data ) { \n\t\t\t\t\t\$(\"#ipResultBlock\" + id).html(data);\n\t\t\t\t});\n\t\t\t\t\n\t\t\t\treturn false;\n\t\t\t});\n\t\t\t\n\t\t});\n\t\t</script>";
    }
    public function Block()
    {
        global $intro;
        $ip = trim($intro->input->get_post('ip'));
        $id = intval($intro->input->get_post('id'));
        $intro->db->query('update ' . PREFIX . ('_ips set type=2 WHERE id=' . $id));
        echo shell_exec('sudo -S iptables -A INPUT -s ' . $ip . ' -j DROP 2>&1');
        echo ' Done!';
        $this->SaveToFile('noEcho');
    }
    public function UnBlock()
    {
        global $intro;
        $ip = trim($intro->input->get_post('ip'));
        $id = intval($intro->input->get_post('id'));
        $intro->db->query('update ' . PREFIX . ('_ips set type=3 WHERE id=' . $id));
        echo shell_exec('iptables -D INPUT -s ' . $ip . ' -j DROP');
        $this->SaveToFile('noEcho');
        echo ' Done!';
    }
    public function Find()
    {
        global $intro;
        $ip = trim($intro->input->get_post('ip'));
        echo shell_exec('sudo -S iptables -L INPUT -v -n | grep "' . $ip . '"');
    }
    public function EditStbCh()
    {
        global $intro;
        $data = [];
        $id = intval($intro->input->get_post('pk'));
        $name = trim($intro->input->get_post('name'));
        $value = trim($intro->input->get_post('value'));
        $data[$name] = $value;
        if( $this->admin['level'] == 1 ) 
        {
            $intro->db->update('' . PREFIX . '_stb_to_iptv', $data, 'id=' . $id);
        }
    }
    public function Del()
    {
        global $intro;
        global $sess_admin;
        global $array;
        $id = intval($intro->input->get_post('id'));
    }
    public function Form($t = '')
    {
        global $intro;
        global $error;
        global $sess_admin;
        global $array;
        global $ch_id;
        global $stb_ch_name;
        if( $_GET != null ) 
        {
            @extract($_GET);
        }
        if( $error || $_POST != null ) 
        {
            @extract($_POST);
        }
        $btn = [];
        $qryLoc = $qryRem = '';
        if( $this->admin['level'] != 1 ) 
        {
            exit( '<h3>Error: you don\'t have permisions to access this file.</h3>' );
        }
        $id = intval($intro->input->get_post('id'));
        $t = ($t == '' ? $intro->input->get_post('t') : $t);
        $this->nav();
        if( $t == 'edit' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'edit');
            $sql = $intro->db->query('SELECT * FROM ' . PREFIX . ('_stb_to_iptv where id=' . $id . ';'));
            $row = $intro->db->fetch_assoc($sql);
            @extract($row);
            $btn['legend_name'] = ' Edit <b>' . $id . '</b>';
            $btn['legend_icon'] = 'icon-edit';
            $btn['name'] = $intro->lang['save_changes'];
            $btn['img_icon'] = 'icon-floppy';
            $btn['action'] = 'doEdit';
            $date = $dateadded;
        }
        else if( $t == 'add' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'add');
            $btn['legend_name'] = 'Add New EPG channel';
            $btn['legend_icon'] = 'icon-plus-squared';
            $btn['name'] = 'Add New';
            $btn['img_icon'] = 'icon-plus-squared';
            $btn['action'] = 'doAdd';
            $qryLoc = ' WHERE type=1 AND `id` NOT IN (SELECT ch_id FROM ' . PREFIX . '_stb_to_iptv) ';
        }
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="' . $btn['legend_icon'] . '"></i> ' . $btn['legend_name'] . ' ', 'primary');
        echo "\n\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . '/' . $btn['action'] . "\" enctype=\"multipart/form-data\">\n\t\t<table class=\"table table-bordered\">\n\t\t\n\t\t<tr>\n\t\t\t<td class=\"success\">Local Channel : </td>\n\t\t\t<td class=\"warning\">STB Channel Name: </td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td class=\"success\">" . $this->ch_local($ch_id, $qryLoc) . ('  ' . $this->error('ch_id') . "</td>\n\t\t\t<td class=\"warning\"><input type=\"text\" name=\"stb_ch_name\"  value=\"" . $stb_ch_name . '" class="form-control">   ' . $this->error('stb_ch_name') . "</td>\n\t\t</tr>\n\t\t\n\t\t<tr>\n\t\t\t<td colspan=\"3\">\n\t\t\t\t<input type=\"hidden\" name=\"t\"  value=\"" . $t . "\">\n\t\t\t\t<input type=\"hidden\" name=\"id\"  value=\"" . $id . "\">\n\t\t\t\t<button type=\"submit\" class=\"btn btn-success\">\n\t\t\t\t<span class=\"" . $btn['img_icon'] . '"></span> ' . $btn['name'] . " \n\t\t\t\t</button>\n\t\t\t\t\n\t\t\t</td>\n\t\t</tr>\n\t\t</table>\n\t\t</form>");
    }
    public function ch_local($ch_id, $qry = '')
    {
        global $intro;
        $html = '<select name="ch_id">';
        $sql = $intro->db->query('SELECT id,stream_display_name from `streams` ' . $qry . ' ORDER BY stream_display_name ASC;');
        $i = 0;
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            $i++;
            $id = $row['id'];
            $stream_display_name = $row['stream_display_name'];
            $html .= ('<option value="' . $id . '" ' . (($ch_id == $id ? 'selected="selected"' : '')) . ('>' . $stream_display_name . '</option>'));
        }
        $html .= '</select>';
        return $html;
    }
    public function doAdd()
    {
        global $intro;
        global $error;
        $ch_id = intval($intro->input->post('ch_id'));
        $stb_ch_name = trim($intro->input->post('stb_ch_name'));
        if( $ch_id == 0 || $stb_ch_name == '' ) 
        {
            if( $ch_id == 0 ) 
            {
                $error['ch_id'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $stb_ch_name == '' ) 
            {
                $error['stb_ch_name'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            $this->Form('add');
            exit();
        }
        $data = [];
        $data['ch_id'] = $ch_id;
        $data['stb_ch_name'] = $stb_ch_name;
        $intro->db->insert(PREFIX . '_stb_to_iptv', $data);
        $intro->redirect($this->appname);
    }
    public function doEdit()
    {
        global $intro;
        global $error;
        $ch_id = intval($intro->input->post('ch_id'));
        $stb_ch_name = trim($intro->input->post('stb_ch_name'));
        $id = intval($intro->input->post('id'));
        if( $ch_id == 0 || $stb_ch_name == '' || $id == 0 ) 
        {
            if( $ch_id == 0 ) 
            {
                $error['ch_id'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $stb_ch_name == '' ) 
            {
                $error['stb_ch_name'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $id == 0 ) 
            {
                $error['ch_id'] = '<span class=error>Error with ID!!!</span>';
                $error['stb_ch_name'] = '<span class=error>Error with ID!!!</span>';
            }
            $this->Form('edit');
            exit();
        }
        $data = [];
        $data['ch_id'] = $ch_id;
        $data['stb_ch_name'] = $stb_ch_name;
        $intro->db->update(PREFIX . '_stb_to_iptv', $data, 'id=' . $id);
        $intro->redirect($this->appname);
    }
}
