<?php 
class Options_AppAdmin
{
    public $appname = null;
    public $base = null;
    public $img_path = null;
    public $bqOrder = [
        '' => 'Default ID A-Z', 
        'id:asc' => 'ID A-Z', 
        'id:desc' => 'ID Z-A', 
        'bouquet_name:asc' => 'Bouquet Name A-Z', 
        'bouquet_name:desc' => 'Bouquet Name Z-A', 
        'view_order:asc' => 'View Order A-Z', 
        'view_order:desc' => 'View Order Z-A'
    ];
    public $db_options = [];
    public $catOrder = [
        '' => 'Default Cat Name A-Z', 
        'id:asc' => 'ID A-Z', 
        'id:desc' => 'ID Z-A', 
        'category_name:asc' => 'Category Name A-Z', 
        'category_name:desc' => 'Category Name Z-A', 
        'cat_order:asc' => 'Cat Order A-Z', 
        'cat_order:desc' => 'Cat Order Z-A'
    ];
    public $moviesOrder = [
        'streams.`order` ASC' => 'Sort order manully', 
        'id desc' => 'New movies first'
    ];
    public function __construct($appname, $base, $img_path = '')
    {
        global $intro;
        $this->admin = $intro->auth->sess_admin();
        if( $this->admin['level'] != 1 ) 
        {
            exit( '<h3>Error: you don\'t have permisions to access this file.</h3>' );
        }
        $this->appname = $appname;
        $this->base = $base;
        $this->img_path = $img_path;
    }
    public function error($index = '')
    {
        global $error;
        return (isset($error[$index]) ? $error[$index] : '');
    }
    public function nav()
    {
        global $intro;
        global $sess_admin;
        echo policy($sess_admin['adminid'], $this->appname . '.php');
        echo "<div class=\"app_nav\">\r\n\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('index') . ('" href="' . $this->base . "/index\"><icon class=\"icon-cog\"> Options </icon></a> \r\n\t\t</div>");
    }
    public function index()
    {
        global $intro;
        global $array;
        global $options;
        $this->nav();
        $sql = $intro->db->query('select * from ' . PREFIX . '_options');
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            $op_name = trim($row['name']);
            $this->db_options[$op_name] = trim($row['val']);
        }
        $btn = [];
        $btn['legend_name'] = 'Edit';
        $btn['legend_icon'] = 'icon-edit';
        $btn['name'] = 'Save';
        $btn['img_icon'] = 'icon-floppy';
        $btn['action'] = 'doEdit';
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="' . $btn['legend_icon'] . '"></i> Options', 'info');
        echo "\r\n\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . '/' . $btn['action'] . "\" enctype=\"multipart/form-data\">\r\n\t\t<table class=\"table table-bordered table-hover\">\r\n\t\t<tr>\r\n\t\t\t<td>Your Server Name:</td>\r\n\t\t\t<td><input dir=ltr type=\"text\" name=\"site_name\" value=\"" . $this->option('site_name') . "\" class=\"form-control\" /></td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>IPTV HOST:</td>\r\n\t\t\t<td>\r\n\t\t\t\t<div class=\"form-inline\">\r\n\t\t\t\t\t<input dir=ltr type=\"text\" name=\"iptv_host\" value=\"" . $this->option('iptv_host') . "\" class=\"form-control\" style=\"min-width:60%\" />\r\n\t\t\t\t\t<p class=\"text-muted\">IPTV Streaming Host. Must be Like: http://example.com:25461/{type}/{user}/{pass}/{ch}.ts</p>\r\n\t\t\t\t\t<p class=\"text-muted\">or Like: http://example.com:25461/{user}/{pass}/{ch}</p>\r\n\t\t\t\t</div>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>VOD/Series HOST:</td>\r\n\t\t\t<td>\r\n\t\t\t\t<div class=\"form-inline\">\r\n\t\t\t\t\t<input dir=ltr type=\"text\" name=\"iptv_host_vod\" value=\"" . $this->option('iptv_host_vod') . "\" class=\"form-control\" style=\"min-width:60%\" />\r\n\t\t\t\t\t<p class=\"text-muted\">Must be Like: http://example.com:25461/{type}/{user}/{pass}/{ch}.{container}</p>\r\n\t\t\t\t</div>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>m3u host:</td>\r\n\t\t\t<td>\r\n\t\t\t\t<div class=\"form-inline\">\r\n\t\t\t\t\t<input dir='ltr' type=\"text\" name=\"m3u_host\" value=\"" . $this->option('m3u_host') . "\" class=\"form-control\" style=\"min-width:60%\" />\r\n\t\t\t\t\t<p class=\"text-muted\">Like: http://example.com:25461/get.php</p>\r\n\t\t\t\t\t<p class=\"text-muted\">Leave it empty to use Main Server Domain</p>\r\n\t\t\t\t</div>\r\n\t\t\t</td>\r\n\t\t</tr>";
        echo "<tr>\r\n\t\t\t<td>api.php File Name:</td>\r\n\t\t\t<td><input type=\"text\" name=\"iptv_api_url\" value=\"" . $this->option('iptv_api_url') . "\" class=\"form-control\" placeholder=\"Default api.php\" />\r\n\t\t\t\t<p class=\"text-muted\">If you changed file name put it here. Leave it empty to use default api.php</p>\r\n\t\t\t</td>\r\n\t\t</tr>";
        echo "<tr>\r\n\t\t\t<td>player_api.php File Name:</td>\r\n\t\t\t<td><input type=\"text\" name=\"iptv_api_player\" value=\"" . $this->option('iptv_api_player') . "\" class=\"form-control\" placeholder=\"Default player_api.php\" />\r\n\t\t\t\t<p class=\"text-muted\">If you changed file name put it here. Leave it empty to use default player_api.php</p>\r\n\t\t\t</td>\r\n\t\t</tr>";
        echo "\r\n\t\t<tr>\r\n\t\t\t<td>IMDB Proxy:</td>\r\n\t\t\t<td>\r\n\t\t\t\t<div class=\"form-inline\">\r\n\t\t\t\t\t<input dir='ltr' type=\"text\" name=\"imdb_proxy\" value=\"" . $this->option('imdb_proxy') . "\" class=\"form-control\" style=\"min-width:60%\" />\r\n\t\t\t\t\t<p class=\"text-muted\">Like: http://example.com/mdb.php</p>\r\n\t\t\t\t</div>\r\n\t\t\t</td>\r\n\t\t</tr>";
        echo "\r\n\t\t<tr>\r\n\t\t\t<td style='color:red'>General User Agent:</td>\r\n\t\t\t<td><input type=\"text\" name=\"user_agent\" value=\"" . $this->option('user_agent') . "\" class=\"form-control\" /></td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Redirect to https://</td>\r\n\t\t\t<td> " . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('https', $this->option('https')) . "\r\n\t\t\t\t<br/> You need to install SSL Certificate on your server.</td>\r\n\t\t</tr>";
        if( isset($options['opt_aum_api']) && $options['opt_aum_api'] == 'yes' ) 
        {
            echo "\r\n\t\t<tr>\r\n\t\t\t<th colspan=2>\r\n\t\t\t\t<span dir=rtl> Auto-Cardsharing (AUM)\r\n\t\t\t\t</span>\r\n\t\t\t</th>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td> API Key</td>\r\n\t\t\t<td><input type=\"text\" name=\"api_key\" value=\"" . $this->option('api_key') . "\" class=\"form-control\" /></td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>API Secret</td>\r\n\t\t\t<td><input type=\"text\" name=\"api_secret\" value=\"" . $this->option('api_secret') . "\" class=\"form-control\" /></td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Allowed IP:</td>\r\n\t\t\t<td><input type=\"text\" name=\"api_allowed_ip\" value=\"" . $this->option('api_allowed_ip') . "\" size=\"30\" /></td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>API Code Length:</td>\r\n\t\t\t<td><input type=\"number\" name=\"api_code_length\" value=\"" . $this->option('api_code_length') . "\" size=\"30\" /> Code length.</td>\r\n\t\t</tr>";
        }
        echo "\r\n\t\t<tr>\r\n\t\t\t<th colspan=2>\r\n\t\t\t\t<span dir=rtl>Billing</span>\r\n\t\t\t</th>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Minimum Top-up Credit:</td>\r\n\t\t\t<td><input type=\"text\" name=\"min_topup_credit\" value=\"" . $this->option('min_topup_credit') . "\" class=\"form-control\" />\r\n\t\t\t\t<p class=\"text-muted\">The minimum credit for Reseller when they add credit to sub-reseller.\r\n\t\t\t\t<br> Example: 80 , if you put 80 the reseller will <b>not</b> add less than 80 Credit.<br\\>\r\n\t\t\t\tEnter 0 to disable this function.</p>\r\n\t\t\t</td>\r\n\t\t</tr>";
        echo "\r\n\t\t<tr>\r\n\t\t\t<th colspan=2>\r\n\t\t\t\t<span dir=rtl> Android APK Page</span>\r\n\t\t\t</th>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td> APK Page URL:</td>\r\n\t\t\t<td><input type=\"text\" name=\"apk_page\" value=\"" . $this->option('apk_page') . "\" class=\"form-control\" /></td>\r\n\t\t</tr>";
        echo "\r\n\t\t<tr>\r\n\t\t\t<th colspan=2>Code Options</th>\r\n\t\t</tr>\r\n\t\t\r\n\t\t<tr>\r\n\t\t\t<td>Enable Multi Code for one Box:</td>\r\n\t\t\t<td> " . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('multi_code', $this->option('multi_code')) . "\r\n\t\t\t\t<br/> (if user uses more than one code on same box, he will extend expire date.)<br/>\r\n\t\t\t\t\t<span dir=rtl>if he input code for 6 months and then input code another 6 months, he will get 12 months.</span></td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Lock Code With MAC Address:</td>\r\n\t\t\t<td>\r\n\t\t\t\t" . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('enable_mac', $this->option('enable_mac')) . "\r\n\t\t\t\t<p class=\"text-muted\">  When user activate we can take MAC and validate with code. So if user MAC changed, the code will not work.</p>\r\n\t\t\t\t</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Lock Code With Serial:</td>\r\n\t\t\t<td>\r\n\t\t\t\t" . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('enable_serial', $this->option('enable_serial')) . ("\r\n\t\t\t\t<p class=\"text-muted\">  When user activate we can take Serial and validate with code. So if serial changed, the code will not work.</p>\r\n\t\t\t\t</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Block Country to Use Master Codes:</td>\r\n\t\t\t<td><input type=\"text\" name=\"master_code_geo_block\" value=\"" . $this->option('master_code_geo_block') . "\" size=\"30\" />\r\n\t\t\t\t<p class=\"text-muted\">Example: US,DE,FR ...etc</p>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Exclude Block By TransID:</td>\r\n\t\t\t<td><input type=\"text\" name=\"master_code_geo_transid\" value=\"" . $this->option('master_code_geo_transid') . "\" size=\"30\" />\r\n\t\t\t\t<p class=\"text-muted\">Example: 102,90,235 ...etc</p>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Block MAC Addresses:</td>\r\n\t\t\t<td>\r\n\t\t\t<p class=\"text-muted\">Put each MAC in a separate line.</p>\r\n\t\t\t<textarea name=\"block_mac\"  style='width:250px;height:100px;'>" . $this->option('block_mac') . "</textarea>\r\n\t\t\t</td>\r\n\t\t</tr>");
        echo "\r\n\t\t<tr>\r\n\t\t\t<th colspan=2> Packages (Bouquets) Options </th>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Bouquets/Packages View Order</td>\r\n\t\t\t<td>" . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('BouquetsOrder', $this->bqOrder, $this->option('BouquetsOrder')) . " (this changes the display order of Bouquets when adding new codes.)</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Categories View Order</td>\r\n\t\t\t<td>" . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('CategoriesOrder', $this->catOrder, $this->option('CategoriesOrder')) . " (this changes the display order of Movies Categories.)</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Movies View Order</td>\r\n\t\t\t<td>" . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('MoviesOrder', $this->moviesOrder, $this->option('MoviesOrder')) . (" (this changes the display order of Movies.)</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Exclude Movies & Series Packages:</td>\r\n\t\t\t<td><input type=\"text\" name=\"exclude_movies_pkg\" value=\"" . $this->option('exclude_movies_pkg') . "\" size=\"30\" />\r\n\t\t\t\t<p class=\"text-muted\">Enter packages ids to exclude from active code dowanlod.</p>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Force admin Bouquets:</td>\r\n\t\t\t<td>") . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('forceAdminUseBouquets', $this->option('forceAdminUseBouquets')) . " (if you set yes, admins will use thier Bouquets and will not see all Bouquets when adding code/user. )</td>\r\n\t\t</tr>";
        echo "\r\n\t\t<tr>\r\n\t\t\t<th colspan=2>Messages</th>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Expire Date:</td>\r\n\t\t\t<td> " . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('expire_date_type', [
            'days' => 'Days Number', 
            'date' => 'Date Only'
        ], $this->option('expire_date_type'), 'Default') . " </td>\r\n\t\t</tr>";
        if( isset($options['opt_islamic_pkg']) && $options['opt_islamic_pkg'] == 'yes' ) 
        {
            echo "\r\n\t\t<tr>\r\n\t\t\t<th colspan=2> Islamic Package </th>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Live Packages IDs:</td>\r\n\t\t\t<td><input type=\"text\" name=\"islam_pkg_live\" value=\"" . $this->option('islam_pkg_live') . "\" size=\"30\" />\r\n\t\t\t\t(Set the IDs for Islamic Packages , so when you enable Islamic Package for code he can see the package or hide it.)\r\n\t\t\t\t</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Movies Categories IDs:</td>\r\n\t\t\t<td><input type=\"text\" name=\"islam_pkg_mov\" value=\"" . $this->option('islam_pkg_mov') . "\" size=\"30\" />\r\n\t\t\t    Example: 35 OR 35,36,37</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Series Categoried IDs:</td>\r\n\t\t\t<td><input type=\"text\" name=\"islam_pkg_series\" value=\"" . $this->option('islam_pkg_series') . "\" size=\"30\" /></td>\r\n\t\t</tr>";
        }
        echo "\r\n\t\t<tr>\r\n\t\t\t<th colspan=2> Movies / VOD </th>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Enable Kids+Series for VOD:</td>\r\n\t\t\t<td>" . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('EnableKidsPlusSeries', $this->option('EnableKidsPlusSeries')) . ("</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Kids Categoried IDs:</td>\r\n\t\t\t<td><input type=\"text\" name=\"vod_kids\" value=\"" . $this->option('vod_kids') . "\" size=\"50\" /></td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Music Categoried IDs:</td>\r\n\t\t\t<td><input type=\"text\" name=\"vod_music\" value=\"" . $this->option('vod_music') . "\" size=\"50\" /></td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Series Categoried IDs:</td>\r\n\t\t\t<td><input type=\"text\" name=\"vod_series\" value=\"" . $this->option('vod_series') . "\" size=\"50\" /></td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Netflix Categoried IDs:</td>\r\n\t\t\t<td><input type=\"text\" name=\"vod_netflix\" value=\"" . $this->option('vod_netflix') . "\" size=\"50\" /></td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Trends Category IDs:</td>\r\n\t\t\t<td><input type=\"text\" name=\"vod_trends\" value=\"" . $this->option('vod_trends') . "\" size=\"50\" /> (for Trends section)</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Shaid Category IDs:</td>\r\n\t\t\t<td><input type=\"text\" name=\"vod_shaid\" value=\"" . $this->option('vod_shaid') . "\" size=\"50\" /> (for Shaid section)</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Top Movies Category IDs:</td>\r\n\t\t\t<td><input type=\"text\" name=\"vod_top_movies\" value=\"" . $this->option('vod_top_movies') . "\" size=\"50\" /> (for Top Movies section)</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Top Series Category IDs:</td>\r\n\t\t\t<td><input type=\"text\" name=\"vod_top_series\" value=\"" . $this->option('vod_top_series') . "\" size=\"50\" /> (for Top Series section)</td>\r\n\t\t</tr>");
        echo "\r\n\t\t<tr>\r\n\t\t\t<th colspan=2>Movies/Series Posters</th>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Use Remote Server for Covers/Photos/Images:</td>\r\n\t\t\t<td>" . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('VodRemoteServer', $this->option('VodRemoteServer')) . ("</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>API:</td>\r\n\t\t\t<td><input type=\"text\" name=\"VodRemoteServerAPI\" value=\"" . $this->option('VodRemoteServerAPI') . "\" size=\"50\" />\r\n\t\t\t<div>\r\n\t\t\tThis remote server will host all Images/ Covers /Photos\r\n\t\t\t</div></td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Upload Path:</td>\r\n\t\t\t<td><input type=\"text\" name=\"VodRemoteUloadPath\" value=\"" . $this->option('VodRemoteUloadPath') . "\" size=\"50\" /></td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Default Image:</td>\r\n\t\t\t<td><input type=\"text\" name=\"VodRemoteDefaultCover\" value=\"" . $this->option('VodRemoteDefaultCover') . "\" size=\"50\" />\r\n\t\t\t<div>\r\n\t\t\tthis image is used as a cover/poster when the vod/series has no cover/poster\r\n\t\t\t</div></td>\r\n\t\t</tr>");
        echo "\r\n\t\t<tr>\r\n\t\t\t<th colspan=2>Free test accounts</th>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Block adding free codes:</td>\r\n\t\t\t<td> " . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('BlockAddFree', $this->option('BlockAddFree')) . (" </td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>1 Day Test Period:</td>\r\n\t\t\t<td><input type=\"number\" name=\"day1_period\" value=\"" . $this->option('day1_period') . "\" min=\"4\" max=\"24\" />\r\n\t\t\t\tHours (min=4 max=24 hours) set the time for test accounts to expire</td>\r\n\t\t</tr>\r\n\t\t\r\n\t\t<tr>\r\n\t\t\t<th colspan=2>Resellers Options</th>\r\n\t\t</tr>") . "<tr>\r\n\t\t\t<td>See Logs:</td>\r\n\t\t\t<td> " . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('AllowReseToSeeLogs', $this->option('AllowReseToSeeLogs')) . " <i> Allow resellers to see Logs. </i></td>\r\n\t\t</tr>\r\n\t\t\r\n\t\t<tr>\r\n\t\t\t<td>(Super Reseller) See ALL Payments?:</td>\r\n\t\t\t<td> " . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('SuperResellSeeAllPays', $this->option('SuperResellSeeAllPays')) . "</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>(Super Reseller) See ALL Codes?:</td>\r\n\t\t\t<td> " . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('SuperResellSeeAllCodes', $this->option('SuperResellSeeAllCodes')) . "</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Default users account:</td>\r\n\t\t\t<td> " . $this->default_users_acct('default_users_acct', $this->option('default_users_acct')) . "\r\n\t\t\t\t<div style='color:#9797a6'>\r\n\t\t\t\t When creating code and activating the code a username is created on xtream.\r\n\t\t\t\t<br> this username will go to this reseller account. Defualt is Admin.\r\n\t\t\t\t<br/> if this list is empty, you need to create a reseller with username=Active in xtream.\r\n\t\t\t\t</div>\r\n\t\t\t</td>\r\n\t\t</tr>";
        echo "\r\n\t\t<tr>\r\n\t\t\t<th colspan=2>Capture</th>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Capture IP data:</td>\r\n\t\t\t<td><input type=\"text\" name=\"capture_ip\" value=\"" . $this->option('capture_ip') . "\" size=\"30\" /> \r\n\t\t\tPut client IP here.\r\n\t\t\t<br/>\r\n\t\t\tThis option is used to Log user data when code fails to activate, data will be saved to Tools->System Log<br/>\r\n\t\t\tYour IP: " . $intro->input->ip_address() . "\r\n\t\t\t</td>\r\n\t\t</tr>";
        if( isset($options['opt_remote_movies']) && $options['opt_remote_movies'] == 'yes' ) 
        {
            echo "\r\n\t\t<tr>\r\n\t\t\t<th colspan=2>Remote Movies/Series (Movies/Series from other Server)</th>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Use Remote Movies?:</td>\r\n\t\t\t<td> " . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('remote_movies_use', $this->option('remote_movies_use')) . ("</td>\r\n\t\t</tr>\t\t\r\n\t\t<tr>\r\n\t\t\t<td>Remote Movies API:</td>\r\n\t\t\t<td><input dir=ltr type=\"text\" name=\"remote_movies_api\" value=\"" . $this->option('remote_movies_api') . "\" class=\"form-control\" /></td>\r\n\t\t</tr>\r\n\t\t\r\n\t\t<tr>\r\n\t\t\t<td>Use Remote Series?:</td>\r\n\t\t\t<td> ") . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('remote_series_use', $this->option('remote_series_use')) . ("</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Remote Series API:</td>\r\n\t\t\t<td><input dir=ltr type=\"text\" name=\"remote_series_api\" value=\"" . $this->option('remote_series_api') . "\" class=\"form-control\" /></td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Cache Time:</td>\r\n\t\t\t<td><input dir=ltr type=\"text\" name=\"cache_time\" value=\"" . $this->option('cache_time') . "\"  /> Minutes</td>\r\n\t\t</tr>");
        }
        if( isset($options['opt_stb_to_iptv']) && $options['opt_stb_to_iptv'] == 'yes' ) 
        {
            echo "\r\n\t\t<tr>\r\n\t\t\t<th colspan=2>SAT to IPTV</th>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Enable SAT to IPTV?:</td>\r\n\t\t\t<td> " . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('enable_sat2iptv', $this->option('enable_sat2iptv')) . "</td>\r\n\t\t</tr>";
        }
        if( isset($options['opt_groups']) && $options['opt_groups'] == 'yes' ) 
        {
            echo "\r\n\t\t<tr>\r\n\t\t\t<th colspan=2>Groups and Brand Names</th>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Enable Groups and Brand Names?:</td>\r\n\t\t\t<td> " . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('enable_groups', $this->option('enable_groups')) . "</td>\r\n\t\t</tr>";
        }
        echo "<tr>\r\n\t\t\t<th colspan=2>Limit the total downloaded of Movies/Series for slow Box based on TransIDs</th>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Trans IDs:</td>\r\n\t\t\t<td><input type=\"text\" name=\"bad_stb_limit_trans\" value=\"" . $this->option('bad_stb_limit_trans') . "\" size=\"60\" /> Separate by comma , </td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Total Movies:</td>\r\n\t\t\t<td><input type=\"text\" name=\"bad_stb_tot_vod\" value=\"" . $this->option('bad_stb_tot_vod') . "\" size=\"15\" />  </td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>total Series:</td>\r\n\t\t\t<td><input type=\"text\" name=\"bad_stb_tot_series\" value=\"" . $this->option('bad_stb_tot_series') . "\" size=\"15\" />  </td>\r\n\t\t</tr>";
        echo "<tr>\r\n\t\t\t<th colspan=2>Statistics</th>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Disable Statistics for Codes:</td>\r\n\t\t\t<td> " . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('DisableStatForCodes', $this->option('DisableStatForCodes')) . "</td>\r\n\t\t</tr>";
        echo "<tr>\r\n\t\t\t<th colspan=2><a name='userToPlayStrm'></a>User/Pass to Play Streams from Streams List</th>\r\n\t\t</tr>\t\r\n\t\t<tr>\r\n\t\t\t<td>Username:</td>\r\n\t\t\t<td><input type=\"text\" name=\"play_strm_user\" value=\"" . $this->option('play_strm_user') . "\" class=\"form-control\" /></td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Password:</td>\r\n\t\t\t<td><input type=\"text\" name=\"play_strm_pass\" value=\"" . $this->option('play_strm_pass') . "\" class=\"form-control\" /></td>\r\n\t\t</tr>";
        echo "<tr>\r\n\t\t\t<th colspan=2>Global Messages</th>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Message to all Resellers:\r\n\t\t\t\t<script src=\"https://code.jquery.com/jquery-3.2.1.slim.min.js\"></script>\r\n\t\t\t\t<link href=\"https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.12/summernote-lite.css\" rel=\"stylesheet\">\r\n\t\t\t\t<script src=\"https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.12/summernote-lite.js\"></script>\r\n\t\t\t</td>\r\n\t\t\t<td><textarea id='global_msg' name=\"global_msg\" class=\"form-control\" style='width:100%;height:250px;'>" . $this->option('global_msg') . "</textarea>\r\n\t\t\t\t<script>\r\n\t\t\t\t  \$('#global_msg').summernote({\r\n\t\t\t\t\tplaceholder: 'type here a message for all  resellers and sub-resellers',\r\n\t\t\t\t\ttabsize: 2,\r\n\t\t\t\t\theight: 250,\r\n\t\t\t\t\ttoolbar: [\r\n\t\t\t\t\t\t['style', ['style','bold', 'italic', 'underline', 'clear']],\t\t\t\t\t\t\r\n\t\t\t\t\t\t['fontsize', ['fontsize']],\r\n\t\t\t\t\t\t['color', ['color']],\r\n\t\t\t\t\t\t['para', ['ul', 'ol', 'paragraph']],\r\n\t\t\t\t\t\t['height', ['height']],\r\n\t\t\t\t\t\t['insert', ['link', 'picture', 'video']],\r\n\t\t\t\t\t\t['view', ['fullscreen', 'codeview']]\r\n\t\t\t\t\t  ]\r\n\t\t\t\t  });\r\n\t\t\t\t</script>\r\n\t\t\t\t<div>\r\n\t\t\t\t\tExpires on: <input type=\"text\" name=\"global_msg_expiry\" value=\"" . $this->option('global_msg_expiry') . '" size="10" placeholder=\'yyyy-mm-dd\' /> <span style=\'color:gray\'>Example: ' . date('Y-m-d', strtotime('+7 days')) . "</span> \r\n\t\t\t\t</div>\r\n\t\t\t</td>\r\n\t\t</tr>";
        echo "\r\n\t\t<tr>\r\n\t\t\t<td class=\"center\" colspan=\"2\">\r\n\t\t\t\t<input type=\"hidden\" name=\"app_name\"  value=\"" . $this->appname . "\">\r\n\t\t\t\t<button class=\"btn btn-success\" type=\"submit\" name=\"app_action\" value=\"doEdit\"><i class=\"icon-floppy\"> </i> " . $btn['name'] . " </button>\t\t\t\t\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t</table>\r\n\t\t</form>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411('');
    }
    public function option($index)
    {
        return (isset($this->db_options[$index]) ? $this->db_options[$index] : '');
    }
    public function selBouquet($html_name, $comp, $txt)
    {
        global $intro;
        global $error;
        $html = '';
        $i = 0;
        $html = "\r\n\t\t<select name=\"" . $html_name . '" id="' . $html_name . '" style="min-width:300px;">';
        $html .= ('<option value="0" selected="selected">' . $txt . '</option>');
        $sql = $intro->db->query('SELECT * FROM bouquets order by bouquet_name ASC');
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            @extract($row);
            $i++;
            $html .= ('<option value="' . $id . '" ' . (($comp == $id ? 'selected="selected"' : '')) . ('>' . $bouquet_name . '</option>'));
        }
        $html .= "\r\n\t\t</select>";
        return $html;
    }
    public function creditSystem($html_name, $comp)
    {
        global $intro;
        global $error;
        $html = '';
        $i = 0;
        $html = "\r\n\t\t<select name=\"" . $html_name . '" id="' . $html_name . '">';
        $html .= '<option value="oversell" selected="selected">Default Allow Oversell</option>';
        foreach( [
            'oversell' => 'Allow Oversell', 
            'restrict' => 'Restrict Credit'
        ] as $key => $val ) 
        {
            $html .= ('<option value="' . $key . '" ' . (($comp == $key ? 'selected="selected"' : '')) . ('>' . $val . '</option>'));
        }
        $html .= "\r\n\t\t</select>";
        return $html;
    }
    public function default_users_acct($html_name, $comp)
    {
        global $intro;
        global $error;
        $html = '';
        $i = 0;
        $html = "\r\n\t\t<select name=\"" . $html_name . '" id="' . $html_name . "\" class=\"searchable chosen\" style=\"min-width:300px;\">\r\n\t\t<option value=\"0\"> None </option>";
        $sql = $intro->db->query('SELECT * FROM reg_users WHERE id=1 OR username LIKE \'%active%\'');
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            @extract($row);
            $i++;
            $html .= ('<option value="' . $id . '" ' . (($comp == $id ? 'selected="selected"' : '')) . ('>' . $username . '</option>'));
        }
        $sql = $intro->db->query('SELECT * FROM ' . PREFIX . '_admin WHERE level=1 order by admin_name');
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            @extract($row);
            $i++;
            $html .= ('<option value="' . $adminid . '" ' . (($comp == $adminid ? 'selected="selected"' : '')) . ('>' . $admin_name . '</option>'));
        }
        $html .= "\r\n\t\t</select>";
        return $html;
    }
    public function doEdit()
    {
        global $intro;
        global $array;
        foreach( $_POST as $key => $val ) 
        {
            if( $key != 'maa' && $key != 'B1' && $key != 'app_name' && $key != 'app_action' ) 
            {
                $val = $intro->input->post($key);
                $val = addslashes($val);
                $this->OptionsCheckNew($key);
                $intro->db->query('update ' . PREFIX . ('_options set val=\'' . $val . '\' where name=\'' . $key . '\''));
            }
        }
        $intro->redirect($this->appname);
    }
    public function OptionsCheckNew($name)
    {
        global $intro;
        $sql = $intro->db->query('select * from ' . PREFIX . ('_options where name=\'' . $name . '\''));
        if( mysqli_num_rows($sql) == 0 ) 
        {
            $intro->db->insert(PREFIX . '_options', ['name' => $name]);
        }
    }
    public function xc()
    {
        global $intro;
        global $array;
        global $options;
        $this->nav();
        echo _obf_0D0713255B04072D042B135C2E233E1902393B0C1B2911();
        $sql = $intro->db->query('SELECT * FROM `settings`');
        $row = $intro->db->fetch_assoc($sql);
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22(' Xtream Setting ', 'info');
        echo "\r\n\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . "/SaveXCsettings\" enctype=\"multipart/form-data\">\r\n\t\t<table class=\"table table-bordered table-hover\">";
        echo "\r\n\t\t<tr>\r\n\t\t\t<td> API IPS</td>\r\n\t\t\t<td><input type=\"text\" name=\"api_ips\" value=\"" . $row['api_ips'] . "\" class=\"form-control\" /></td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>API Password</td>\r\n\t\t\t<td><input type=\"text\" name=\"api_pass\" value=\"" . $row['api_pass'] . "\" class=\"form-control\" /></td>\r\n\t\t</tr>\r\n\t\t";
        echo "\r\n\t\t<tr>\r\n\t\t\t<td class=\"center\" colspan=\"2\">\r\n\t\t\t\t\r\n\t\t\t\t<button class=\"btn btn-success\" type=\"submit\"><i class=\"icon-floppy\"> </i>  Save </button>\t\t\t\t\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t</table>\r\n\t\t</form>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411('');
    }
    public function SaveXCsettings()
    {
        global $intro;
        $data = [];
        $data['api_ips'] = trim($intro->input->post('api_ips'));
        $data['api_pass'] = trim($intro->input->post('api_pass'));
        $intro->db->update('`settings`', $data, 'id=1');
        _obf_0D103C08311F24242D2F281F0B3E28333032320A031011('Success. Saved!', 'success');
        $intro->redirect($this->appname, 'xc');
    }
}
