<?php 
include('./includes/ssh/ssh.php');
class Servers_AppAdmin
{
    public $appname = null;
    public $base = null;
    public $img_path = null;
    public $qry_admin = '';
    public $qry_admin_where = '';
    public $path = '/home/xtreamcodes/iptv_xtream_codes/';
    public $admin = [];
    public $limits = 0;
    public $FilesToClean = [
        'echo \'\' > /home/xtreamcodes/iptv_xtream_codes/logs/error.log', 
        'echo \'\' > /home/xtreamcodes/iptv_xtream_codes/php/var/log/php-fpm.log', 
        'echo \'\' > /home/xtreamcodes/iptv_xtream_codes/logs/rtmp_error.log', 
        'echo \'\' > /home/xtreamcodes/iptv_xtream_codes/logs/rtmp_access.log', 
        'echo \'\' > /var/log/apache2/error.log', 
        'echo \'\' > /var/log/apache2/access.log', 
        'echo \'\' > /var/log/apache2/modsec_audit.log', 
        'echo \'\' > /var/log/apache2/other_vhosts_access.log', 
        'echo \'\' > /var/log/nginx.log', 
        'rm -f /var/log/*.gz', 
        'rm -f /var/log/*.0', 
        'rm -f /var/log/*.1', 
        'rm -f /var/log/apache2/*.gz', 
        'rm -f /var/log/apache2/*.0', 
        'rm -f /var/log/apache2/*.1', 
        'rm /home/xtreamcodes/iptv_xtream_codes/streams/*', 
        'rm /home/xtreamcodes/iptv_xtream_codes/tmp/*'
    ];
    public function __construct($appname, $base, $img_path = '')
    {
        global $intro;
        global $options;
        $this->appname = $appname;
        $this->base = $base;
        $this->img_path = $img_path;
        $this->admin = $intro->auth->sess_admin();
        if( $this->admin['level'] != 1 ) 
        {
            $this->qry_admin = ' and adminid=' . intval($this->admin['adminid']);
            $this->qry_admin_where = ' where adminid=' . intval($this->admin['adminid']);
        }
        if( $this->admin['level'] != 1 ) 
        {
            exit( 'error: no perms' );
        }
        if( isset($options['opt_serv_limit']) && intval($options['opt_serv_limit']) > 0 ) 
        {
            $this->limits = intval($options['opt_serv_limit']);
        }
    }
    public function error($index = '')
    {
        global $error;
        return (isset($error[$index]) ? $error[$index] : '');
    }
    public function nav()
    {
        global $intro;
        global $sess_admin;
        echo policy($sess_admin['adminid'], $this->appname . '.php');
        echo "<div class=\"app_nav\">\n\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('index') . ('" href="' . $this->base . "/index\"><icon class=\"icon-building\">Servers</icon></a> \n\t\t<a class=\"btn btn-") . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('Monitoring') . ('" href="' . $this->base . "/Monitoring\"><icon class=\"icon-flash\">Monitoring Servers</icon></a> \n\t\t<a class=\"btn btn-") . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('Form') . ('" href="' . $this->base . "/Form?t=add\"><icon class=\"icon-plus-squared\">Add New Server</icon></a> \n\t\t<a class=\"btn btn-") . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('KeyToPass') . ('" href="' . $this->base . "/KeyToPass?t=add\"><icon class=\"icon-key\">Key To Pass</icon></a> \n\t\t<a class=\"btn btn-danger\" href=\"" . $this->base . "/ReloadAll?t=add\" OnClick=\"return confirm('This will Reload ALL LB?');\"><icon class=\"icon-arrows-cw\">Reload LBs</icon></a> \n\t\t<a class=\"btn btn-") . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('MainInstall') . ('" href="' . $this->base . "/MainInstall?t=add\"><icon class=\"icon-cog-alt\">Main Install</icon></a> \n\t\t\n\t\t</div>");
    }
    public function index()
    {
        global $intro;
        global $array;
        $qry = $queryadmin = $params = $txt = '';
        $order = trim($intro->input->get_post('order'));
        $this->nav();
        $sql2 = $intro->db->query('SHOW COLUMNS FROM `streaming_servers` LIKE \'server_ip6\';');
        if( $intro->db->returned_rows == 0 ) 
        {
            $intro->db->query(' ALTER TABLE `streaming_servers` ADD `server_ip6` VARCHAR(250) NULL DEFAULT NULL AFTER `server_ip`;');
        }
        $sql2 = $intro->db->query('SHOW COLUMNS FROM `streaming_servers` LIKE \'view_order\';');
        if( $intro->db->returned_rows == 0 ) 
        {
            $intro->db->query(' ALTER TABLE `streaming_servers` ADD `view_order` MEDIUMINT NOT NULL AFTER `timeshift_only`; ');
        }
        $rows_per_page = 50;
        if( $order == '' ) 
        {
            $order = 'view_order:ASC';
        }
        $order = str_replace(':', ' ', $order);
        $result = $intro->db->query('SELECT *  ,(SELECT count(*) FROM `user_activity_now` WHERE server_id=ss.id) AS online_clients ,(SELECT count(server_id) FROM `streams_sys` WHERE server_id=ss.id) AS total_streams' . (' from streaming_servers ss ' . $qry . ' order by ' . $order));
        $totrows = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<h4 style=\'display:inline\'><i class="icon-building"></i> Servers (' . $totrows . ') ' . $txt . '</h4>');
        $sql_root = (isset($intro->option['sql_root']) ? _obf_0D13231A3D06231D2E0915212A173318050804182F1322($intro->option['sql_root']) : '');
        $sql_lb_user = (isset($intro->option['sql_lb_user']) ? _obf_0D13231A3D06231D2E0915212A173318050804182F1322($intro->option['sql_lb_user']) : '');
        $sql_lb_pass = (isset($intro->option['sql_root']) ? _obf_0D13231A3D06231D2E0915212A173318050804182F1322($intro->option['sql_lb_pass']) : '');
        if( $sql_root == '' || $sql_lb_user == '' || $sql_lb_pass == '' ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232("<h4>\n\t\t\tStep1: Edit all servers and set SSH port and Passwords.<br/>\n\t\t\tStep2: Choose any LB (not Main Server) AND Read Config File, then take (db_user) , (db_pass)<br/>\n\t\t\tStep3: Edit Main Server and Set (MySQL and LB user & Pass) 1-(MySQL Root Pass) 2-(db_user) , 3-(db_pass).\n\t\t\t</h4>", 'danger');
        }
        $is_cheat = false;
        if( $this->limits != 0 && $this->limits < $totrows ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232("<h1>\n\t\t\tError: You are cheating LB limit.\n\t\t\t</h1>", 'danger');
            $is_cheat = true;
        }
        echo "\n\t\t<div class=\"XXXtable-responsive\">\n\t\t<table class=\"table table-hover table-bordered\" id=\"table_codes\">\n        <thead>\n\t    <tr>\n\t\t\n\t\t\t<th>ID " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('id', 'index') . "</th>\n\t\t\t<th> Status </th>\n\t\t\t<th> Server Name </th>\n\t\t\t<th> Order</th>\n\t\t\t<th> IP/ Domain </th>\n\t\t\t<th>Latency</th>";
        if( $intro->input->get('pwd') == 'false' ) 
        {
            echo '<td> </td>';
        }
        echo "<th> Http Ports </th>\n\t\t\t<th> Streams </th>\n\t\t\t<th> Clients </th>\n\t\t\t<th>OS</th>\n\t\t\t<th> Network </th>\n\t\t\t<th>CPU</th>\n\t\t\t<th>RAM</th>\n\t\t\t<th>Options</th>\n\t    </tr>\n\t\t</thead>\n\t\t\n\t\t<tbody>";
        $i = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            $watchdog_data = json_decode($watchdog_data, true);
            $total_mem = (isset($watchdog_data['total_mem']) ? $watchdog_data['total_mem'] : '');
            $cpu = (isset($watchdog_data['cpu']) ? $watchdog_data['cpu'] : '');
            $cpu_avg = (isset($watchdog_data['cpu_avg']) ? $watchdog_data['cpu_avg'] : '');
            $total_mem_used_percent = (isset($watchdog_data['total_mem_used_percent']) ? $watchdog_data['total_mem_used_percent'] : '');
            $cpu_cores = (isset($watchdog_data['cpu_cores']) ? $watchdog_data['cpu_cores'] : '');
            $total_mem_used = (isset($watchdog_data['total_mem_used']) ? $watchdog_data['total_mem_used'] : '');
            $total_running_streams = (isset($watchdog_data['total_running_streams']) ? $watchdog_data['total_running_streams'] : '');
            $total_mem_used_percent = round($total_mem_used_percent, 2);
            if( time() - $last_check_ago > 360 && $can_delete == 1 && $status != 3 && $status != 0 ) 
            {
                $status = 2;
            }
			
			
			
			
         if( in_array($status, [ 0, 1 ]) ) 
        {
            $status_txt = [ "<span class=\"icon-globe\" style=\"color:#777777\" title=\"Disabled\"></span>", "<span class=\"icon-globe\" style=\"color:green\" title=\"online\"></span>" ][$status];
        }
        else
        {
            if( $status == 2 ) 
            {
                if( 0 < $last_check_ago ) 
                {
                    $downTime = intval((time() - $last_check_ago) / 60);
                    if( 5 <= $downTime ) 
                    {
                        $intro->db->query_fast("UPDATE `streaming_servers` SET `watchdog_data`='[]' WHERE `id`=" . $id . ";");
                    }

                    $status_txt = "<span class=\"icon-globe animate-spin\" style=\"color:#d93600\" title=\"Offline for " . $downTime . " minutes\"></span> ";
                }
                else
                {
                    $status_txt = "<span class=\"icon-globe\" style=\"color:#d93600\"></span>";
                }

            }
            else
            {
                if( $status == 3 ) 
                {
                    $status_txt = "<span class=\"icon-cog animate-spin\" style=\"color:#0040ff\" title=\"Installing system ... \"></span>";
                }

            }

        }
			
			
			
			
			
			
			
			
            $tot = json_decode($geoip_countries, true);
            if( count($tot) > 0 ) 
            {
                $geoTXT = '<br/><span style=\'color:#bbbbbb\'>GeoIP Set (' . count($tot) . ')</span>';
            }
            else
            {
                $geoTXT = '';
            }
            echo "\n\t\t\t<tr " . ((intval($intro->input->get_post('server')) == $id ? 'style=\'background:#a6ff4c;\'' : '')) . (">\n\t\t\t\t<td class=\"center\">" . $id . '<a name="' . $id . "\"></a></td>\n\t\t\t\t<td class=\"center\">" . $status_txt . ' ') . (($timeshift_only == 1 ? '<br/><span class="label label-warning">Timeshift Only</span>' : '')) . ("</td>\n\t\t\t\t<td class=\"center\">" . $server_name . ' ' . $geoTXT . "</td>\n\t\t\t\t<td class=\"center\"><span class=\"editable\" data-type=\"text\" data-pk=\"" . $id . '" data-name="view_order">' . $view_order . "</span></td>\n\t\t\t\t<td class=\"center\">" . $server_ip . ' ') . (($domain_name != '' ? '<br/>' . $domain_name : '')) . ("</td>\n\t\t\t\t<td class=\"center\">" . $latency . '</td>');
            if( $intro->input->get('pwd') == 'false' ) 
            {
                echo '<td>' . $ssh_port . '</td>';
                echo '<td>' . _obf_0D13231A3D06231D2E0915212A173318050804182F1322($ssh_password) . '</td>';
            }
            echo "\n\t\t\t\t<td class=\"center\">" . $http_broadcast_port . "<br/>\n\t\t\t\t<a title='Additional'>";
            if( $id == 1 && $http_ports_add != '' ) 
            {
                echo 'Add.</a> Port: ' . $http_ports_add . " <!--<br/>\n\t\t\t\t\thttps port: " . $https_broadcast_port . " <br/>\n\t\t\t\t\t<a title='Additional'>Add.</a> Port: " . $https_ports_add . '-->';
            }
            echo "\n\t\t\t\t</td>\n\t\t\t\t<td class=\"center\"><span style='color:#238c00'><b>" . $total_running_streams . '</b></span>/' . $total_streams . " </td>\n\t\t\t\t<td class=\"center\"><span style='color:#0036d9'><b>" . $online_clients . '</b></span>/' . $total_clients . " </td>\n\t\t\t\t<td class=\"center\" style='font-size:11px'>" . $system_os . "</td>\n\t\t\t\t<td class=\"center\">" . $network_interface . "</td>\n\t\t\t\t<td class=\"center\">" . $this->getProgress($cpu_avg, 'cpu', 100) . "</td>\n\t\t\t\t<td class=\"ltr\">" . $this->getProgress($total_mem_used_percent) . "</td>\n\n\t\t\t\t<td class=\"center\">";
            echo "\n\t\t\t\t\t<div class=\"btn-group\">\n                        <button class=\"btn btn-primary dropdown-toggle\" href=\"#\" data-toggle=\"dropdown\">\n                        <span class='icon-cog'></span> <span class=\"caret\"></span>\n                        </button>\n                        <ul class=\"dropdown-menu stay-open pull-right\" role=\"menu\" style=\"padding: 5px; min-width: 200px;\">";
            if( !$is_cheat ) 
            {
                echo '<li><a href="' . $this->base . '/Form?t=edit&amp;id=' . $id . '" title="' . $intro->lang['edit'] . '"><span class="btn btn-info btn-sm icon-edit"></span> Edit Server</a></li>';
                echo "\n\t\t\t\t\t\t\t<li><a class=\"AjaxModal\" href=\"" . $this->base . '/RestartStreams?NH=1&id=' . $id . "\" title=\"Restart All Streams\" OnClick=\"return false;\"><span class=\"btn btn-success btn-sm icon-podcast\"></span> Restart Streams</a></li>\n\t\t\t\t\t\t\t<li><a class=\"AjaxModal\" href=\"" . $this->base . '/KillCons?NH=1&id=' . $id . "\" title=\"Kill All active Connectios\" OnClick=\"return false;\"><span class=\"btn btn-warning btn-sm icon-emo-shoot\"></span> Kill Connections</a></li>\n\t\t\t\t\t\t\t<li><a class=\"AjaxModal MarkMe\" href=\"" . $this->base . '/Reload?id=' . $id . '" title="Restart Services on Server" data-con="This will set config and rstart services?"><span class="btn btn-info btn-sm icon-arrows-cw"></span> Reload Server</a></li>';
                if( $id != 1 ) 
                {
                    echo "\n\t\t\t\t\t\t\t<li><a class=\"\" href=\"" . $this->base . '/ReInstall?id=' . $id . '" title="Install services on Server" OnClick="return confirm(\'This will re-install media server. Are you Sure?\');"><span class="btn btn-info btn-sm icon-wrench"></span> Remake Server</a></li>';
                }
                echo "\n\t\t\t\t\t\t\t<li><a class=\"AjaxModal\" href=\"" . $this->base . '/FixGeoIP?id=' . $id . '" title="This will fix GeoIP DB" data-con="This will fix GeoLocation Database When it\'s  Size is Zero. Are you Sure?"><span class="btn btn-warning btn-sm icon-wrench"></span> Fix GeoIP DB</a></li>';
                echo "\t\n\t\t\t\t\t\t\t<li><a class=\"AjaxModal\" href=\"" . $this->base . '/ReadConfig?id=' . $id . "\" title=\"read config file on server\" data-con=\"This will read config file data?\"><span class=\"btn btn-info btn-sm icon-list\"></span> Read Config File</a></li>\n\t\t\t\t\t\t\t<li><a class=\"AjaxModal\" href=\"" . $this->base . '/IpTables?id=' . $id . "\" title=\"Flush IPTABLES\" data-con=\"This will clean all blocked IPs: iptables -F\"><span class=\"btn btn-success btn-sm icon-list\"></span> Flush Firewall iptables -F</a></li>\n\t\t\t\t\t\t\t<li><a class=\"AjaxModal\" href=\"" . $this->base . '/CleanAll?id=' . $id . "\" title=\"Clean All\" data-con=\"This will clean all logs,tmp,streams tmp\"><span class=\"btn btn-warning btn-sm icon-bug\"></span> Clean temp,logs,streams</a></li>\n\t\t\t\t\t\t\t<li><a class=\"AjaxModal\" href=\"" . $this->base . '/DiskSpace?id=' . $id . "\" title=\"Disk Space\" data-con=\"This will read Disk Space\"><span class=\"btn btn-default btn-sm icon-hdd\"></span> View Disk Space</a></li>\n\t\t\t\t\t\t\t<li><a class=\"AjaxModal\" href=\"" . $this->base . '/Youtube?id=' . $id . "\" title=\"Update Youtube\" data-con=\"This will Update youtube library\"><span class=\"btn btn-default btn-sm icon-youtube\"></span> Update Youtube</a></li>\n\t\t\t\t\t\t\t<li><a class=\"AjaxModal\" href=\"" . $this->base . '/Reboot?NH=1&id=' . $id . '" title="Reboot Server" data-con="Warning this will reboot server?"><span class="btn btn-default btn-sm icon-ccw"></span> Reboot Server</a></li>';
            }
            if( $id != 1 ) 
            {
                echo '<li><a class="" class="p_del" href="' . $this->base . '/DelForm?id=' . $id . '"  title="Delete Server" OnClick="return confirm(\'Are you Sure?\');"><span class="btn btn-danger btn-sm icon-trash"></span> Delete </a></li>';
            }
            echo "\n                        </ul>\n\t\t\t\t\t</div>";
        }
        echo "</tbody>\n\t\t\t</table>\n\t\t\t</div>";
        if( in_array($this->admin['level'], [
            1, 
            5, 
            8, 
            9
        ]) ) 
        {
            echo "<div class=\"text-center\">\n\t\t\t<a href=\"" . $this->base . "/FixOrder\">Fix View Order</a>\n\t\t\t<div id=\"AjaxResult\">.....</div>\n\t\t\t</div>";
        }
        echo "<ul>\n\t\t\t\t<li>LB: is the Load Balancer server.</li>\n\t\t\t\t<li>Reload Server: Will update LB server config files and Nginx Media server ports.</li>\t\n\t\t\t\t<li>Remake Server: This will Install/re-install the Media Server on selectd LB.</li>\t\n\t\t\t</ul>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo "<style>\n\t\t.ui-state-highlight\n\t\t{\n\t\t\tborder:1px dotted #ccc;\n\t\t\tcursor:move;\n\t\t}\n\t\t</style>\n\t\t<script>\n\t\t/* inline */\n\t\t\$.fn.editable.defaults.mode = 'inline';     \n\t\t\$('.editable').editable({\n\t\t\turl: '" . $this->base . "/EditInPlace?NH=1',\n\t\t\tsuccess: function(response) {\n\t\t\t/*alert(response);*/\n\t\t\t}\n\t\t});\n\t\t</script>";
        echo "<script>\n\t\t/*\$(document).on('click', '.MarkMe', function(e){\n\t\t\t\n\t\t});\t*/\n\t\t</script>";
    }
    public function FixOrder()
    {
        global $intro;
        $sql = $intro->db->query('select id from streaming_servers order by view_order ASC');
        $w1 = 0;
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            $w1++;
            $id = intval($row['id']);
            $intro->db->query('UPDATE streaming_servers SET view_order=' . $w1 . ' WHERE id=' . $id . ' ');
        }
        $intro->redirect($this->appname);
    }
    public function EditInPlace()
    {
        global $intro;
        $id = intval($intro->input->get_post('pk'));
        $name = trim($intro->input->get_post('name'));
        $value = trim($intro->input->get_post('value'));
        $data = [];
        $data[$name] = $value;
        $intro->db->update('streaming_servers', $data, 'id=' . $id);
    }
    public function Form($t = '')
    {
        global $intro;
        global $error;
        global $sess_admin;
        global $array;
        global $server_name;
        global $domain_name;
        global $server_ip;
        global $server_ip6;
        global $http_broadcast_port;
        global $ssh_port;
        global $total_clients;
        global $status;
        global $server_type;
        global $network_guaranteed_speed;
        global $network_interface;
        global $ssh_password;
        global $http_ports_add;
        global $https_broadcast_port;
        global $https_ports_add;
        global $rtmp_port;
        global $geoip_countries;
        global $system_os;
        global $enable_geoip;
        global $geoip_type;
        global $isp_names;
        global $isp_type;
        global $enable_isp;
        global $timeshift_only;
        global $boost_fpm;
        global $timeshift_only;
        global $geoip_type;
        global $isp_type;
        global $total_services;
        global $persistent_connections;
        global $persistent_connections;
        global $total_services;
        if( $error || $_POST != null ) 
        {
            @extract($_POST);
        }
        $id = intval($intro->input->get_post('id'));
        $t = ($t == '' ? $intro->input->get_post('t') : $t);
        $this->nav();
        $btn = [];
        if( $t == 'edit' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'edit');
            $sql = $intro->db->query('SELECT * FROM streaming_servers WHERE id=' . $id . ';');
            $row = $intro->db->fetch_assoc($sql);
            @extract($row);
            $btn['legend_name'] = 'Update Server: <b>' . $id . '</b>';
            $btn['legend_icon'] = 'icon-edit';
            $btn['name'] = $intro->lang['save_changes'];
            $btn['img_icon'] = 'icon-floppy';
            $btn['action'] = 'doEdit';
            if( $intro->input->post('sql_lb_pass') == '' ) 
            {
                $sql_lb_pass = '';
            }
            if( $intro->input->post('sql_root') == '' ) 
            {
                $sql_root = '';
            }
        }
        else if( $t == 'add' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'add');
            $btn['legend_name'] = 'Add New Server';
            $btn['legend_icon'] = 'icon-plus-squared';
            $btn['name'] = $intro->lang['save'];
            $btn['img_icon'] = 'icon-plus-squared';
            $btn['action'] = 'doAdd';
            $status = ($status == '' ? 1 : $status);
            $http_broadcast_port = ($http_broadcast_port == '' ? 8080 : $http_broadcast_port);
            $https_broadcast_port = ($https_broadcast_port == '' ? 2087 : $https_broadcast_port);
            $rtmp_port = ($rtmp_port == '' ? 25462 : $rtmp_port);
            $timeshift_only = ($timeshift_only == '' ? 0 : $timeshift_only);
            $total_services = ($total_services == '' ? 3 : $total_services);
            $totrows = $intro->db->dcount('id', 'streaming_servers');
            if( $this->limits != 0 && $this->limits < $totrows ) 
            {
                echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232("<h1>\n\t\t\t\tError: You exceeded your LB limit.\n\t\t\t\t</h1>", 'danger');
                exit();
            }
        }
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="' . $btn['legend_icon'] . '"></i> ' . $btn['legend_name'] . ' ', 'info');
        echo "\n\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . '/' . $btn['action'] . "\" enctype=\"multipart/form-data\">\n\t\t<div class=\"table-responsive\">\n\t\t<table class=\"table table-bordered table-hover table-striped\">\n\t\t<!--<tr>\n\t\t\t<td>Media Server :  <span style='color:#ff0000'>*</span></td>\n\t\t\t<td>" . _obf_0D1029270D2B062E351F39253F1B39061037400E130401('server_type', [
            '1' => 'Flussoic', 
            '2' => 'XtreamCodes', 
            '3' => 'VOD/Series Server'
        ], $server_type) . (' ' . $this->error('server_type') . "</td>\n\t\t</tr>-->\n\t\t<tr>\n\t\t\t<td>Server Name :  <span style='color:#ff0000'>*</span></td>\n\t\t\t<td><input  type=\"text\" name=\"server_name\" value=\"" . $server_name . '" size="30"> ' . $this->error('server_name') . "</td>\n\t\t</tr>\n\t\t\n\t\t\n\t\t<tr>\n\t\t\t<td>Server IPv4 : <span style='color:#ff0000'>*</span></td>\n\t\t\t<td><input  type=\"text\" name=\"server_ip\" value=\"" . $server_ip . '" size="30"> ' . $this->error('server_ip') . "</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Server IPv6 : </td>\n\t\t\t<td><input  type=\"text\" name=\"server_ip6\" value=\"" . $server_ip6 . '" size="40"> ' . $this->error('server_ip6') . "</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Domain Name :  </td>\n\t\t\t<td><input  type=\"text\" name=\"domain_name\" value=\"" . $domain_name . '" size="30"> ' . $this->error('domain_name') . "</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td class='success'>HTTP Broadcast Port : <span style='color:#ff0000'>*</span></td>\n\t\t\t<td><input  type=\"text\" name=\"http_broadcast_port\" value=\"" . $http_broadcast_port . '" size="10"> ' . $this->error('http_broadcast_port') . "</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Additional HTTP Broadcast Port : </td>\n\t\t\t<td><input  type=\"text\" name=\"http_ports_add\" value=\"" . $http_ports_add . '" size="40"> ' . $this->error('http_ports_add') . "</td>\n\t\t</tr>\n\t\t\n\t\t\n\t\t<tr>\n\t\t\t<td><span style='color:#1a6600'>HTTPS Broadcast Port :</span> </td>\n\t\t\t<td><input  type=\"text\" name=\"https_broadcast_port\" value=\"" . $https_broadcast_port . '" size="10"> ' . $this->error('https_broadcast_port') . "</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td><span style='color:#1a6600'>Additional HTTPS Broadcast Port : </span></td>\n\t\t\t<td><input  type=\"text\" name=\"https_ports_add\" value=\"" . $https_ports_add . '" size="40"> ' . $this->error('https_ports_add') . "</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>RTMP Port :</td>\n\t\t\t<td><input  type=\"text\" name=\"rtmp_port\" value=\"" . $rtmp_port . '" size="20"> ' . $this->error('rtmp_port') . "</td>\n\t\t</tr>\n\t\t\n\t\t<tr>\n\t\t\t<th colspan=2>SSH</th>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td class='success'>SSH Port : <span style='color:#ff0000'>*</span></td>\n\t\t\t<td><input  type=\"text\" name=\"ssh_port\" value=\"" . $ssh_port . '" size="10"> ' . $this->error('ssh_port') . "</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td class='success'>SSH Password : <span style='color:#ff0000'>*</span></td>\n\t\t\t<td><input type=\"text\" name=\"ssh_password\" value=\"\" size=\"20\"> " . $this->error('ssh_password') . "\n\t\t\t") . (($t == 'edit' ? 'Type new password to change the saved one.' : '')) . ("</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<th colspan=2>Cpacity</th>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Total Allowed Clients: </td>\n\t\t\t<td><input  type=\"text\" name=\"total_clients\" value=\"" . $total_clients . '" size="15"> ' . $this->error('total_clients') . " </td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Network Guaranteed Speed (MB) : </td>\n\t\t\t<td><input  type=\"text\" name=\"network_guaranteed_speed\" value=\"" . $network_guaranteed_speed . '" size="15"> ' . $this->error('network_guaranteed_speed') . "</td>\n\t\t</tr>");
        if( $t == 'edit' ) 
        {
            echo "\n\t\t<tr>\n\t\t\t<td>Network Interface : </td>\n\t\t\t<td><input  type=\"text\" name=\"network_interface\" value=\"" . $network_interface . '" size="15"> ' . $this->error('network_interface') . "\n\t\t\t<span>if you know network interface name, then put it here.</span></td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>System OS : </td>\n\t\t\t<td><input  type=\"text\" name=\"system_os\" value=\"" . $system_os . '" size="30"> ' . $this->error('system_os') . "\n\t\t\t</td>\n\t\t</tr>";
        }
        echo "\n\t\t<tr>\n\t\t\t<th colspan=\"2\">Perfomance Settings</th>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Use MySQL Persistent Connections:</td>\n\t\t\t<td>" . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('persistent_connections', $persistent_connections, 'yes') . ("</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Total FastCGI Services : </td>\n\t\t\t<td><input  type=\"text\" name=\"total_services\" value=\"" . $total_services . '" size="30"> ' . $this->error('total_services') . "</td>\n\t\t</tr>\n\t\t\n\t\t<tr>\n\t\t\t<th colspan=\"2\">GeoIP Load Balancer Settings</th>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Enable GeoIP Balancing:</td>\n\t\t\t<td>") . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('enable_geoip', $enable_geoip, 'yes') . "</td>\n\t\t</tr>\n\t\t\n\t\t<tr>\n\t\t\t<td>GeoIP Countries :</td>\n\t\t\t<td>" . _obf_0D192107040A1D2A031C033725325B09190E3D34050511('geoip_countries[]', json_decode($geoip_countries, true)) . "</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>GeoIP Balancing Type:</td>\n\t\t\t<td>" . _obf_0D1029270D2B062E351F39253F1B39061037400E130401('geoip_type', $array['BalancingType'], $geoip_type, '', '') . "</td>\n\t\t</tr>";
        echo "\n\t\t<tr>\n\t\t\t<th colspan=\"2\">ISP/Organization Load Balancer Settings</th>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Enable ISP Balancing:</td>\n\t\t\t<td>" . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('enable_isp', $enable_isp, 'yes') . "</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>ISPs/Organizations :</td>\n\t\t\t<td> __SOON__ </td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>ISP Balancing Type:</td>\n\t\t\t<td>" . _obf_0D1029270D2B062E351F39253F1B39061037400E130401('isp_type', $array['BalancingType'], $isp_type, '', '') . "</td>\n\t\t</tr>";
        if( $t == 'edit' && $id == 1 && $intro->input->get('set_sql') == 1 ) 
        {
            $sql_root = (isset($intro->option['sql_root']) ? _obf_0D13231A3D06231D2E0915212A173318050804182F1322($intro->option['sql_root']) : '');
            $sql_lb_user = (isset($intro->option['sql_lb_user']) ? _obf_0D13231A3D06231D2E0915212A173318050804182F1322($intro->option['sql_lb_user']) : '');
            $sql_lb_pass = (isset($intro->option['sql_root']) ? _obf_0D13231A3D06231D2E0915212A173318050804182F1322($intro->option['sql_lb_pass']) : '');
            if( $intro->input->post('sql_lb_pass') == '' ) 
            {
                $sql_lb_pass = '';
            }
            if( $intro->input->post('sql_root') == '' ) 
            {
                $sql_root = '';
            }
            echo "\n\t\t<tr>\n\t\t\t<th colspan=2>MySQL and LB user & Pass</th>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>1- MySQL Root Pass : </td>\n\t\t\t<td><input type=\"text\" name=\"sql_root\" value=\"" . $sql_root . '" size="50"> ' . $this->error('sql_root') . "</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>2- LB mysql username (db_user): </td>\n\t\t\t<td><input type=\"text\" name=\"sql_lb_user\" value=\"" . $sql_lb_user . '" size="30"> ' . $this->error('sql_lb_user') . "\n\t\t\t<br/>This user and pass is used by LB to connect to main server.</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>3- LB mysql password (db_pass): </td>\n\t\t\t<td><input type=\"text\" name=\"sql_lb_pass\" value=\"" . $sql_lb_pass . '" size="50"> ' . $this->error('sql_lb_pass') . "\n\t\t\t<br/>When you change user/pass you need to Reload All LB servers</td>\n\t\t</tr>";
        }
        echo "\n\t\t<tr>\n\t\t\t<td>Enabled? : </td>\n\t\t\t<td>" . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('status', $status) . (' ' . $this->error('status') . " ( choose No to disable server )</td>\n\t\t</tr>\n\t\t\n\t\t<tr>\n\t\t\t<td>TimeShift Only? : </td>\n\t\t\t<td>") . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('timeshift_only', $timeshift_only) . (' ' . $this->error('timeshift_only') . " \n\t\t\t<span class='red'>(If you choose yes, no stream will work and No user will connect to server.)</span></td>\n\t\t</tr>\n\t\t\n\t\t<tr>\n\t\t\t<td></td>\n\t\t\t<td>\n\t\t\t\t<input type=\"hidden\" name=\"app_name\"  value=\"" . $this->appname . "\">\n\t\t\t\t<input type=\"hidden\" name=\"t\"  value=\"" . $t . "\">\n\t\t\t\t<input type=\"hidden\" name=\"id\"  value=\"" . $id . "\">\n\t\t\t\t<button type=\"submit\" name=\"app_action\" value=\"" . $btn['action'] . "\">\n\t\t\t\t\t<i class=\"" . $btn['img_icon'] . '"></i> ' . $btn['name'] . " \n\t\t\t\t</button>\n\t\t\t</td>\n\t\t</tr>\n\t\t</table>\n\t\t</div>\n\t\t</form>");
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function doAdd()
    {
        global $intro;
        global $error;
        $t = trim($intro->input->post('t'));
        $geoip_countries = $intro->input->post('geoip_countries');
        $isp_names = $intro->input->post('isp_names');
        $server_name = trim($intro->input->post('server_name'));
        $domain_name = trim($intro->input->post('domain_name'));
        $server_ip = trim($intro->input->post('server_ip'));
        $http_broadcast_port = intval($intro->input->post('http_broadcast_port'));
        $http_ports_add = trim($intro->input->post('http_ports_add'));
        $https_broadcast_port = trim($intro->input->post('https_broadcast_port'));
        $https_ports_add = trim($intro->input->post('https_ports_add'));
        $rtmp_port = trim($intro->input->post('rtmp_port'));
        $ssh_port = intval($intro->input->post('ssh_port'));
        $total_clients = intval($intro->input->post('total_clients'));
        $status = intval($intro->input->post('status'));
        $enable_geoip = intval($intro->input->post('enable_geoip'));
        $enable_isp = intval($intro->input->post('enable_isp'));
        $network_guaranteed_speed = intval($intro->input->post('network_guaranteed_speed'));
        $network_interface = trim($intro->input->post('network_interface'));
        $ssh_password = trim($intro->input->post('ssh_password'));
        if( $server_name == '' || $server_ip == '' || $http_broadcast_port == 0 || $ssh_port == 0 || $t == 'add' && $ssh_password == '' ) 
        {
            if( $server_name == '' ) 
            {
                $error['server_name'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $server_ip == '' ) 
            {
                $error['server_ip'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $http_broadcast_port == 0 ) 
            {
                $error['http_broadcast_port'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $ssh_port == 0 ) 
            {
                $error['ssh_port'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $t == 'add' && $ssh_password == '' ) 
            {
                $error['ssh_password'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            $this->Form($t);
            exit();
        }
        if( is_array($geoip_countries) && count($geoip_countries) > 0 ) 
        {
            $geoip_countries = json_encode($geoip_countries);
        }
        else
        {
            $geoip_countries = '[]';
        }
        $data = [];
        $data['server_name'] = $server_name;
        $data['domain_name'] = $domain_name;
        $data['server_ip'] = $server_ip;
        $data['geoip_countries'] = $geoip_countries;
        $data['http_broadcast_port'] = $http_broadcast_port;
        $data['http_ports_add'] = $http_ports_add;
        $data['https_broadcast_port'] = $https_broadcast_port;
        $data['https_ports_add'] = $https_ports_add;
        $data['rtmp_port'] = $rtmp_port;
        $data['ssh_port'] = $ssh_port;
        $data['total_clients'] = $total_clients;
        $data['status'] = $status;
        $data['network_guaranteed_speed'] = $network_guaranteed_speed;
        $data['network_interface'] = $network_interface;
        $data['server_ip6'] = trim($intro->input->post('server_ip6'));
        $data['system_os'] = trim($intro->input->post('system_os'));
        $data['enable_geoip'] = intval($intro->input->post('enable_geoip'));
        $data['geoip_type'] = trim($intro->input->post('geoip_type'));
        if( $data['geoip_type'] == '' ) 
        {
            $data['geoip_type'] = 'low_priority';
        }
        $data['persistent_connections'] = intval($intro->input->post('persistent_connections'));
        $data['total_services'] = intval($intro->input->post('total_services'));
        if( is_array($isp_names) && count($isp_names) > 0 ) 
        {
            $isp_names = json_encode($isp_names);
        }
        else
        {
            $isp_names = '[]';
        }
        $data['enable_isp'] = intval($intro->input->post('enable_isp'));
        $data['isp_type'] = trim($intro->input->post('isp_type'));
        if( $data['isp_type'] == '' ) 
        {
            $data['isp_type'] = 'low_priority';
        }
        $data['isp_names'] = $isp_names;
        $data['timeshift_only'] = intval($intro->input->post('timeshift_only'));
        if( $t == 'add' ) 
        {
            if( $ssh_password != '' ) 
            {
                $data['ssh_password'] = _obf_0D273F082A1A171D2A1A31302D14310D23290B17081F32($ssh_password);
            }
            $data['view_order'] = $this->getMaxViewOrder();
            $intro->db->insert('streaming_servers', $data);
            $id = $intro->db->insert_id();
        }
        else if( $t == 'edit' ) 
        {
            if( strlen($ssh_password) > 5 ) 
            {
                $data['ssh_password'] = _obf_0D273F082A1A171D2A1A31302D14310D23290B17081F32($ssh_password);
            }
            $id = intval($intro->input->post('id'));
            $intro->db->update('streaming_servers', $data, 'id=' . $id);
            if( $id == 1 ) 
            {
                $this->OptionsCheckNew('sql_root');
                $this->OptionsCheckNew('sql_lb_user');
                $this->OptionsCheckNew('sql_lb_pass');
                if( strlen($intro->input->post('sql_root')) > 4 ) 
                {
                    $sql_root = _obf_0D273F082A1A171D2A1A31302D14310D23290B17081F32(trim($intro->input->post('sql_root')));
                    $intro->db->update('' . PREFIX . '_options', ['val' => $sql_root], 'name=\'sql_root\'');
                }
                if( strlen($intro->input->post('sql_lb_user')) > 4 ) 
                {
                    $sql_lb_user = _obf_0D273F082A1A171D2A1A31302D14310D23290B17081F32(trim($intro->input->post('sql_lb_user')));
                    $intro->db->update('' . PREFIX . '_options', ['val' => $sql_lb_user], 'name=\'sql_lb_user\'');
                }
                if( strlen($intro->input->post('sql_lb_pass')) > 4 ) 
                {
                    $sql_lb_pass = _obf_0D273F082A1A171D2A1A31302D14310D23290B17081F32(trim($intro->input->post('sql_lb_pass')));
                    $intro->db->update('' . PREFIX . '_options', ['val' => $sql_lb_pass], 'name=\'sql_lb_pass\'');
                }
            }
        }
        $intro->redirect($this->appname, 'index', '?server=' . $id . '#' . $id);
    }
    public function getMaxViewOrder()
    {
        global $intro;
        $sql = $intro->db->query('select max(view_order) as maxNum from streaming_servers;');
        $w1 = 0;
        $row = $intro->db->fetch_assoc($sql);
        return intval($row['maxNum']) + 1;
    }
    public function doEdit()
    {
        $this->doAdd();
    }
    public function OptionsCheckNew($name)
    {
        global $intro;
        $sql = $intro->db->query('select * from ' . PREFIX . ('_options where name=\'' . $name . '\''));
        if( mysqli_num_rows($sql) == 0 ) 
        {
            $intro->db->insert(PREFIX . '_options', ['name' => $name]);
        }
    }
    public function Monitoring()
    {
        global $intro;
        global $array;
        $refresh = $intro->input->get_post('refresh');
        if( $refresh == '' ) 
        {
            $this->nav();
        }
        $result = $intro->db->query('SELECT *  ,(SELECT count(*) FROM `user_activity_now` WHERE server_id=ss.id) AS online_clients from streaming_servers ss WHERE `status`=1 order by view_order ASC');
        $totrows = $intro->db->returned_rows;
        if( $refresh == '' ) 
        {
            echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Monitoring Servers (' . $totrows . ') <div class=\'pull-right\' id=\'cdown_timer\'></div>');
            echo '<div class="row" id=\'div_refresh\'>';
        }
        $i = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            if( time() - $last_check_ago > 360 && $can_delete == 1 && $status != 3 && $status != 0 ) 
            {
                $status = 2;
            }
            echo '<div class="col-sm-6 col-md-3 col-lg-3">' . $this->watchdog_data($status, $server_name, $server_ip, $watchdog_data, $online_clients, $total_clients, $network_guaranteed_speed) . '</div>';
        }
        if( $refresh == '' ) 
        {
            echo '</div>';
            echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
            echo "<script>\n\t\t\t\$(document).ready(function() {\n\t\t\t\tvar counter = 15;\n\t\t\t\tvar interval = setInterval(function() {\n\t\t\t\t\tcounter--;\n\t\t\t\t\tif (counter <= 0) {\n\t\t\t\t\t\tcounter = 16;\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}else{\n\t\t\t\t\t\t\$('#cdown_timer').text(counter);\n\t\t\t\t\t\tif(counter == 1){\n\t\t\t\t\t\t\t\$('#div_refresh').load('" . $this->base . "/Monitoring?NH=1&refresh=ok');\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}, 1000);\n\t\t\t});\n\t\t\t</script>";
        }
    }
    public function watchdog_data($status, $name, $server_ip, $watchdog_data, $online_clients, $total_clients, $network_guaranteed_speed)
    {
        $html = '';
        $watchdog_data = json_decode($watchdog_data, true);
        $total_mem = $watchdog_data['total_mem'];
        $cpu = $watchdog_data['cpu'];
        $cpu_cores = $watchdog_data['cpu_cores'];
        $total_mem_used = $watchdog_data['total_mem_used'];
        $total_mem_used_percent = round($watchdog_data['total_mem_used_percent'], 2);
        $bytes_sent = round($watchdog_data['bytes_sent'], 2);
        $bytes_received = round($watchdog_data['bytes_received'], 2);
        if( $status == 0 ) 
        {
            $bg = 'disabled';
        }
        else if( $status == 2 ) 
        {
            $bg = 'bg-danger blinking danger';
        }
        else
        {
            $bg = '';
        }
        $html = "<table class=\"table table-condensed table-bordered\">\n\t\t<tr>\n\t\t\t<td colspan=\"2\" class='text-center success " . $bg . '\'>' . $name . "</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>CPUs: " . $cpu . ' /Cores: ' . $cpu_cores . " </td>\n\t\t\t<td>" . $this->getProgress($watchdog_data['cpu_avg'], 'cpu', 120) . "</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>CPU Load Average:</td>\n\t\t\t<td>" . $watchdog_data['cpu_load_average'] . "</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td class='info'>RAM: (" . round($total_mem / 1024 / 1024) . "GB)</td>\n\t\t\t<td>" . $this->getProgress($total_mem_used_percent) . ("</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td class='warning'>Clients:</td>\n\t\t\t<td>" . $online_clients . '/' . $total_clients . "</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Live Streams:</td>\n\t\t\t<td>") . $watchdog_data['total_running_streams'] . "</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Uptime:</td>\n\t\t\t<td>" . $watchdog_data['uptime'] . ("</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Network (UP/Down):</td>\n\t\t\t<td>" . $bytes_sent . '/' . $bytes_received . ' ') . $this->getProgress($bytes_sent, 'net', $network_guaranteed_speed) . ("</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Uplink:</td>\n\t\t\t<td>" . $network_guaranteed_speed . "</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td colspan=\"2\" class='text-center primary'>" . $server_ip . "</td>\n\t\t</tr>\n\t\t</table>");
        return $html;
    }
    public function getProgress($val, $for = '', $valuemax = 100)
    {
        $color = 'success';
        if( $for == 'cpu' ) 
        {
            if( $val > 10 && $val <= 50 ) 
            {
                $color = 'warning';
            }
            if( $val > 50 ) 
            {
                $color = 'danger';
            }
        }
        else if( $for == 'net' ) 
        {
            $guaranteed_speed = $valuemax;
            $valuemax = 100;
            if( $guaranteed_speed == 0 ) 
            {
                return '';
            }
            $val = round($val / $guaranteed_speed * 100, 2);
            if( $val > 75 && $val < 90 ) 
            {
                $color = 'warning';
            }
            if( $val >= 90 ) 
            {
                $color = 'danger';
            }
        }
        else
        {
            if( $val > 30 && $val < 60 ) 
            {
                $color = 'warning';
            }
            if( $val > 60 ) 
            {
                $color = 'danger';
            }
        }
        return "\n\t\t<div class=\"progress\" style=\"margin-bottom: 0;\">\n\t\t\t<div class=\"progress-bar progress-bar-" . $color . '" role="progressbar" aria-valuenow="' . $val . "\"\n\t\t\t\taria-valuemin=\"0\" aria-valuemax=\"" . $valuemax . '" style="width:' . $val . "%;color:#777777;\">\n\t\t\t\t" . $val . "%\n\t\t\t</div>\n\t\t</div>";
    }
    public function FixGeoIP()
    {
        global $intro;
        $sid = intval($intro->input->get_post('id'));
        $sql = $intro->db->query('SELECT * FROM streaming_servers WHERE id=' . $sid . ';');
        $row = $intro->db->fetch_assoc($sql);
        $server_ip = $row['server_ip'];
        $ssh_port = $row['ssh_port'];
        $http_broadcast_port = $row['http_broadcast_port'];
        $pwd = _obf_0D13231A3D06231D2E0915212A173318050804182F1322($row['ssh_password']);
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Fix no clients connect for server: ' . $row['server_name'] . ' ' . $row['server_ip'], 'success');
        $ssh = new Net_SSH2($server_ip, $ssh_port);
        if( !$ssh->login('root', $pwd) ) 
        {
            exit( _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<h4>Error: Login Failed. Please check ssh passowrd and port.</h4>', 'danger') );
        }
        $ssh->exec(' wget -t 5 -O /tmp/GeoLite2.mmdb  http://intro.ps/uploads/GeoLite2.mmdb');
        $size = intval($ssh->exec(' du  /tmp/GeoLite2.mmdb | cut -f1'));
        if( $size > 3000 ) 
        {
            $ssh->exec(' chattr -ia ' . $this->path . 'GeoLite2.mmdb && cp -f /tmp/GeoLite2.mmdb ' . $this->path . 'GeoLite2.mmdb ' . (' && chattr +i ' . $this->path . 'GeoLite2.mmdb '));
            $size2 = intval($ssh->exec(' du  ' . $this->path . 'GeoLite2.mmdb | cut -f1'));
            if( $size2 < 3000 ) 
            {
                echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232("<h3>Error: Failed to update GeoLite2.mmdb. Your server is Down Now!!!<br/>\n\t\t\t\tContact us now.</h3>", 'danger');
            }
            else
            {
                echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<h3>Problem fixed.</h3>');
            }
        }
        else
        {
            $size = intval($ssh->exec(' du  ' . $this->path . 'GeoLite2.mmdb | cut -f1'));
            if( $size < 3000 ) 
            {
                echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232("<h3>Error: Failed to update GeoLite2.mmdb. Your server is Down Now!!!<br/>\n\t\t\t\tContact us now.</h3>", 'danger');
            }
        }
        $ssh->disconnect();
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function IpTables()
    {
        global $intro;
        $sid = intval($intro->input->get_post('id'));
        $sql = $intro->db->query('SELECT * FROM streaming_servers WHERE id=' . $sid . ';');
        $row = $intro->db->fetch_assoc($sql);
        $server_ip = $row['server_ip'];
        $ssh_port = $row['ssh_port'];
        $http_broadcast_port = $row['http_broadcast_port'];
        $pwd = _obf_0D13231A3D06231D2E0915212A173318050804182F1322($row['ssh_password']);
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Flush Firewall: ' . $row['server_name'] . ' ' . $row['server_ip'], 'success');
        $ssh = new Net_SSH2($server_ip, $ssh_port);
        if( !$ssh->login('root', $pwd) ) 
        {
            exit( _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<h4>Error: Login Failed. Please check ssh passowrd and port.</h4>', 'danger') );
        }
        $config = $ssh->exec(' csf -tf ');
        $config = $ssh->exec('iptables -F');
        $ssh->disconnect();
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<h4>Success. (' . $config . ')</h4>', 'success');
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function CleanAll()
    {
        global $intro;
        $sid = intval($intro->input->get_post('id'));
        $sql = $intro->db->query('SELECT * FROM streaming_servers WHERE id=' . $sid . ';');
        $row = $intro->db->fetch_assoc($sql);
        $server_ip = $row['server_ip'];
        $ssh_port = $row['ssh_port'];
        $http_broadcast_port = $row['http_broadcast_port'];
        $pwd = _obf_0D13231A3D06231D2E0915212A173318050804182F1322($row['ssh_password']);
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Clean tmp, logs, streams tmp: ' . $row['server_name'] . ' ' . $row['server_ip'], 'success');
        $ssh = new Net_SSH2($server_ip, $ssh_port);
        if( !$ssh->login('root', $pwd) ) 
        {
            exit( _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<h4>Error: Login Failed. Please check ssh passowrd and port.</h4>', 'danger') );
        }
        $rep = '';
        foreach( $this->FilesToClean as $cms ) 
        {
            $ssh->exec(' ' . $cms . ' &>/dev/null &');
        }
        $ssh->disconnect();
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<h4>Success.</h4>', 'success');
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function Youtube()
    {
        global $intro;
        $sid = intval($intro->input->get_post('id'));
        $sql = $intro->db->query('SELECT * FROM streaming_servers WHERE id=' . $sid . ';');
        $row = $intro->db->fetch_assoc($sql);
        $server_ip = $row['server_ip'];
        $ssh_port = $row['ssh_port'];
        $http_broadcast_port = $row['http_broadcast_port'];
        $pwd = _obf_0D13231A3D06231D2E0915212A173318050804182F1322($row['ssh_password']);
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Update Youtube libraray: ' . $row['server_name'] . ' ' . $row['server_ip'], 'success');
        $ssh = new Net_SSH2($server_ip, $ssh_port);
        if( !$ssh->login('root', $pwd) ) 
        {
            exit( _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<h4>Error: Login Failed. Please check ssh passowrd and port.</h4>', 'danger') );
        }
        $ssh->exec(' sudo apt-get install -y python &>/dev/null &');
        $ssh->exec(' sudo rm -f /home/xtreamcodes/iptv_xtream_codes/bin/youtube &>/dev/null &');
        $ssh->exec(' sudo wget https://yt-dl.org/downloads/latest/youtube-dl -O /home/xtreamcodes/iptv_xtream_codes/bin/youtube &>/dev/null &');
        $ssh->exec(' sudo chmod a+rx /home/xtreamcodes/iptv_xtream_codes/bin/youtube &>/dev/null &');
        $ssh->disconnect();
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<h4>Success.</h4>', 'success');
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function Reboot()
    {
        global $intro;
        $sid = intval($intro->input->get_post('id'));
        $sql = $intro->db->query('SELECT * FROM streaming_servers WHERE id=' . $sid . ';');
        $row = $intro->db->fetch_assoc($sql);
        $server_ip = $row['server_ip'];
        $ssh_port = $row['ssh_port'];
        $http_broadcast_port = $row['http_broadcast_port'];
        $pwd = _obf_0D13231A3D06231D2E0915212A173318050804182F1322($row['ssh_password']);
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Reboot server : ' . $row['server_name'] . ' ' . $row['server_ip'], 'success');
        $ssh = new Net_SSH2($server_ip, $ssh_port);
        if( !$ssh->login('root', $pwd) ) 
        {
            exit( _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<h4>Error: Login Failed. Please check ssh passowrd and port.</h4>', 'danger') );
        }
        $data = $ssh->exec('reboot &>/dev/null &');
        $ssh->disconnect();
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232(' Reboot Success ');
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function DiskSpace()
    {
        global $intro;
        $sid = intval($intro->input->get_post('id'));
        $sql = $intro->db->query('SELECT * FROM streaming_servers WHERE id=' . $sid . ';');
        $row = $intro->db->fetch_assoc($sql);
        $server_ip = $row['server_ip'];
        $ssh_port = $row['ssh_port'];
        $http_broadcast_port = $row['http_broadcast_port'];
        $pwd = _obf_0D13231A3D06231D2E0915212A173318050804182F1322($row['ssh_password']);
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Disk Space for : ' . $row['server_name'] . ' ' . $row['server_ip'], 'success');
        $ssh = new Net_SSH2($server_ip, $ssh_port);
        if( !$ssh->login('root', $pwd) ) 
        {
            exit( _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<h4>Error: Login Failed. Please check ssh passowrd and port.</h4>', 'danger') );
        }
        $data = $ssh->exec(' df -h');
        $ssh->disconnect();
        $rep = $this->getFreeSpace($data);
        if( is_array($rep) ) 
        {
            echo "<table class=\"table table-bordered table-hover\">\n\t\t\t<tr>\n\t\t\t\t<th>File System</th>\n\t\t\t\t<th>Size</th>\n\t\t\t\t<th>Used</th>\n\t\t\t\t<th>Free</th>\n\t\t\t\t<th>Percent</th>\n\t\t\t\t<th>Mount</th>\n\t\t\t</tr>";
            foreach( $rep as $k => $row ) 
            {
                $bg = $warn = '';
                if( trim($row['mount']) == '/' ) 
                {
                    $per = intval($row['percentage']);
                    if( $per >= 80 && $per < 90 ) 
                    {
                        $bg = 'warning';
                    }
                    else if( $per >= 90 ) 
                    {
                        $bg = 'danger';
                    }
                    if( $per >= 95 ) 
                    {
                        $warn = '<span class="btn btn-danger blinking"> Disk is Full !!! </span>';
                    }
                }
                echo '<tr class="' . $bg . "\">\n\t\t\t\t<td>" . $row['filesystem'] . "</td>\n\t\t\t\t<td class=\"text-center\">" . $row['size'] . "</td>\n\t\t\t\t<td class=\"text-center\">" . $row['used'] . "</td>\n\t\t\t\t<td class=\"text-center\">" . $row['avail'] . "</td>\n\t\t\t\t<td class=\"text-center\">" . $row['percentage'] . "</td>\n\t\t\t\t<td>" . $row['mount'] . ' ' . $warn . "</td>\n\t\t\t\t</tr>";
            }
            echo '</table>';
        }
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function getFreeSpace($data)
    {
        $rReturn = [];
        $rLines = explode("\n", $data);
        array_shift($rLines);
        foreach( $rLines as $rLine ) 
        {
            $rSplit = explode(' ', preg_replace('!\s+!', ' ', trim($rLine)));
            if( strlen($rSplit[0]) > 0 ) 
            {
                $rReturn[] = [
                    'filesystem' => $rSplit[0], 
                    'size' => $rSplit[1], 
                    'used' => $rSplit[2], 
                    'avail' => $rSplit[3], 
                    'percentage' => $rSplit[4], 
                    'mount' => join(' ', array_slice($rSplit, 5, count($rSplit) - 5))
                ];
            }
        }
        return $rReturn;
    }
    public function ReadConfig()
    {
        global $intro;
        $sid = intval($intro->input->get_post('id'));
        $sql = $intro->db->query('SELECT * FROM streaming_servers WHERE id=' . $sid . ';');
        $row = $intro->db->fetch_assoc($sql);
        $server_ip = $row['server_ip'];
        $ssh_port = $row['ssh_port'];
        $http_broadcast_port = $row['http_broadcast_port'];
        $pwd = _obf_0D13231A3D06231D2E0915212A173318050804182F1322($row['ssh_password']);
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Config file for Server Name: ' . $row['server_name'] . ' ' . $row['server_ip'], 'success');
        $ssh = new Net_SSH2($server_ip, $ssh_port);
        if( !$ssh->login('root', $pwd) ) 
        {
            exit( _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<h4>Error: Login Failed. Please check ssh passowrd and port.</h4>', 'danger') );
        }
        $config = $ssh->exec(' cat  ' . $this->path . 'config');
        $ssh->disconnect();
        $config = json_decode(_obf_0D1D2F29402E020A0C4009070E240127221B5B18364032(trim($config)), true);
        if( is_array($config) ) 
        {
            echo '<table class="table table-bordered table-hover" >';
            foreach( $config as $Key => $Val ) 
            {
                if( ($Key == 'db_user' || $Key == 'db_pass') && $intro->input->get_post('view') != 'all' ) 
                {
                    $Val = '************';
                }
                echo "<tr>\n\t\t\t\t\t\t<td>" . $Key . "</td>\n\t\t\t\t\t\t<td>" . $Val . "</td>\n\t\t\t\t</tr>";
            }
            echo '</table>';
        }
        else
        {
            exit( _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<h4>Error: config file is unreadable.</h4>', 'danger') );
        }
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function ReloadAll()
    {
        global $intro;
        $result = $intro->db->query('SELECT * from streaming_servers where id !=1 order by view_order ASC');
        $totrows = $intro->db->returned_rows;
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<h4 style=\'display:inline\'><i class="icon-building"></i>Reload Servers (' . $totrows . ') </h4>');
        echo "\n\t\t<div class=\"table-responsive\">\n\t\t<table class=\"table table-hover table-bordered\" id=\"table_codes\">\n        <thead>\n\t    <tr>\n\t\t\n\t\t\t<th>#</th>\n\t\t\t<th> Server Name </th>\n\t\t\t<th> IP</th>\n\t\t\t<th> Result </th>\n\t    </tr>\n\t\t</thead>\n\t\t<tbody>";
        $i = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            echo "\n\t\t\t<tr>\n\t\t\t\t<td>" . $i . "</td>\n\t\t\t\t<td>" . $server_name . "</td>\n\t\t\t\t<td>" . $server_ip . "</td>\n\t\t\t\t<td>";
            $this->Reload(true, $id);
            echo "</td>\n\t\t\t</tr>";
        }
        echo "\n\t\t</tbody>\n\t\t</table>";
    }
    public function Reload($Bulk = false, $sid = 0)
    {
        global $intro;
        if( $sid == 0 ) 
        {
            $sid = intval($intro->input->get_post('id'));
        }
        $sql = $intro->db->query('SELECT * FROM streaming_servers WHERE id=' . $sid . ';');
        $row = $intro->db->fetch_assoc($sql);
        $server_ip = $row['server_ip'];
        $ssh_port = $row['ssh_port'];
        $http_broadcast_port = $row['http_broadcast_port'];
        $http_ports_add = $row['http_ports_add'];
        $https_broadcast_port = $row['https_broadcast_port'];
        $https_ports_add = $row['https_ports_add'];
        $rtmp_port = $row['rtmp_port'];
        $txt_port = 'listen ' . $http_broadcast_port . ';';
        if( $http_ports_add != '' ) 
        {
            $ex = explode(',', $http_ports_add);
            foreach( $ex as $newpor ) 
            {
                $txt_port .= ('listen ' . $newpor . ';');
            }
        }
        $txt_port .= ('listen ' . $https_broadcast_port . ' ssl;');
        if( $https_ports_add != '' ) 
        {
            $ex = explode(',', $https_ports_add);
            foreach( $ex as $newpor ) 
            {
                $txt_port .= ('listen ' . $newpor . ' ssl;');
            }
        }
        $pwd = _obf_0D13231A3D06231D2E0915212A173318050804182F1322($row['ssh_password']);
        if( !$Bulk ) 
        {
            $this->nav();
            echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22();
        }
        $ssh = new Net_SSH2($server_ip, $ssh_port);
        if( !$ssh->login('root', $pwd) ) 
        {
            $loginRes = _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<h4>Error: Login Failed</h4>', 'danger');
            if( !$Bulk ) 
            {
                exit( $loginRes );
            }
            else
            {
                echo $loginRes;
                return null;
            }
        }
        $ssh->exec(' rm -f /home/xtreamcodes/iptv_xtream_codes/php/*.pid >/dev/null');
        if( $sid != 1 ) 
        {
            $string_to_send = $this->getMainString($sid);
            $success = false;
            $rep = $ssh->exec(' sudo echo \'' . $string_to_send . '\' > ' . $this->path . 'config && echo \'config:success\';');
            $config = @$ssh->exec(' cat  ' . $this->path . 'config');
            $config = json_decode(_obf_0D1D2F29402E020A0C4009070E240127221B5B18364032(trim($config)), true);
            if( @count($config) > 8 ) 
            {
                $success = true;
                echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('config update success.');
            }
            else
            {
                echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('config update faild. Check disk space using the command# df -h', 'danger');
            }
        }
        if( $success || $sid == 1 ) 
        {
            if( $sid == 1 ) 
            {
                echo $ssh->exec(' sed -i \'s/listen.*ssl; *ssl_certificate/' . $txt_port . 'ssl_certificate/\' ' . $this->path . 'nginx/conf/nginx.conf');
            }
            else
            {
                echo $ssh->exec(' sed -i \'0,/listen [0-9]*;/s//listen ' . $http_broadcast_port . ';/\' ' . $this->path . 'nginx/conf/nginx.conf');
            }
            if( $sid == 1 ) 
            {
                $cmd = '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';
                $ssh->exec(' echo \'' . $cmd . '\' | base64 --decode > ' . $this->path . 'wwwdir/dir.php && chown xtreamcodes:xtreamcodes ' . $this->path . 'wwwdir/*');
            }
            $restart = $ssh->exec($this->path . 'start_services.sh &>/dev/null &');
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232(' Success ');
            if( !$Bulk ) 
            {
                echo '<a href="' . $this->base . '/index/?server=' . $sid . '#' . $sid . '" class="btn btn-success">Click here to go Back</a>';
            }
        }
        if( !$Bulk ) 
        {
            echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        }
    }
    public function ReInstall()
    {
        global $intro;
        $sid = intval($intro->input->get_post('id'));
        $sql = $intro->db->query('SELECT * FROM streaming_servers WHERE id=' . $sid . ' AND id!=1;');
        $row = $intro->db->fetch_assoc($sql);
        $server_ip = $row['server_ip'];
        $ssh_port = $row['ssh_port'];
        $http_broadcast_port = $row['http_broadcast_port'];
        $pwd = _obf_0D13231A3D06231D2E0915212A173318050804182F1322($row['ssh_password']);
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Install Services for: ' . $row['server_name'] . ' ' . $row['server_ip'], 'warning');
        $ssh = new Net_SSH2($server_ip, $ssh_port);
        if( !$ssh->login('root', $pwd) ) 
        {
            exit( _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<h4>Error: SSH Login Failed , please check IP/PORT/Password.</h4>', 'danger') );
        }
        else
        {
            $cmd = $intro->db->dbquery();
            $cmd = base64_decode($cmd);
            $cmd = str_replace('{http_broadcast_port}', $http_broadcast_port, $cmd);
            $cmd = base64_encode($cmd);
            $network = $ssh->exec(' sudo netstat -ie | grep -B1 "' . $server_ip . '" | head -n1 | awk \'{print $1}\' ');
            $network = preg_replace('/[^a-zA-Z0-9]/', '', $network);
            if( strlen($network) < 3 ) 
            {
                $network = $ssh->exec(' sudo ip link | awk -F: \'$0 !~ "lo|vir|wl|^[^0-9]"{print $2;getline}\'');
                $network = preg_replace('/[^a-zA-Z0-9]/', '', $network);
            }
            $system_os = $ssh->exec(' lsb_release -d ');
            $system_os = str_replace('Description:', '', $system_os);
            $system_os = trim($system_os);
            $intro->db->query('UPDATE streaming_servers SET system_os=\'' . $system_os . '\',network_interface=\'' . $network . '\' WHERE id=' . $sid . ';');
            $ssh->exec(' echo \'' . $cmd . '\' | base64 --decode > /tmp/0 && chmod 755 /tmp/0');
            $ssh->exec('  /tmp/0 &>/dev/null & ');
            $ssh->exec(' rm -f /tmp/0 ');
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232("<h4>Installation started.\n\t\t\t<br/> Please don't refresh page.\n\t\t\t<br/> Please wait .... \n\t\t\t</h4>", 'danger');
            $prog = 0;
            echo "\n\t\t\t<div id='DIV_prog_Area'>\n\t\t\t\t<div class=\"progress\">\n\t\t\t\t\t<div class=\"progress-bar progress-bar-success\" role=\"progressbar\" aria-valuenow=\"" . $prog . "\"\n\t\t\t\t\t\taria-valuemin=\"0\" aria-valuemax=\"100\" style=\"width:" . $prog . "%\">\n\t\t\t\t\t\t<span id='progress-bar-valper'>" . $prog . "</span>% Complete\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t</div>";
            echo "<script>\n\t\t\t\$(document).ready(function() {\n\t\t\t\tvar auto_refresh = setInterval(\n\t\t\t\tfunction () {\n\t\t\t\t\t\n\t\t\t\t\t\$.get( '" . $this->base . '/Progress?NH=1&id=' . $sid . "', function( result ) {\n\t\t\t\t\t\t\$('.progress-bar').css(\"width\", result + '%');\n\t\t\t\t\t\t\$('#progress-bar-valper').html(result);\n\t\t\t\t\t\tif(result == '100'){\n\t\t\t\t\t\t\twindow.location.href = '" . $this->base . '/Reload?id=' . $sid . "';\n\t\t\t\t\t\t}\n\t\t\t\t\t  \n\t\t\t\t\t});\n\t\t\t\t}, 10000);\n\t\t\t});\n\t\t\t</script>";
        }
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function Progress()
    {
        global $intro;
        $sid = intval($intro->input->get_post('id'));
        $sql = $intro->db->query('SELECT * FROM streaming_servers WHERE id=' . $sid . ';');
        $row = $intro->db->fetch_assoc($sql);
        $server_ip = $row['server_ip'];
        $ssh_port = $row['ssh_port'];
        $http_broadcast_port = $row['http_broadcast_port'];
        $pwd = _obf_0D13231A3D06231D2E0915212A173318050804182F1322($row['ssh_password']);
        $ssh = new Net_SSH2($server_ip, $ssh_port);
        if( !$ssh->login('root', $pwd) ) 
        {
            exit( _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<h4>Error: Login Failed</h4>', 'danger') );
        }
        $prog = $ssh->exec(' cat /tmp/intro.prog ');
        echo intval($prog);
    }
    public function un_used()
    {
    }
    public function getMainString($server_id)
    {
        global $intro;
        global $config;
        $sql = $intro->db->query('SELECT * FROM streaming_servers WHERE id=1;');
        $row = $intro->db->fetch_assoc($sql);
        $server_ip = trim($row['server_ip']);
        $ssh_port = intval($row['ssh_port']);
        $http_broadcast_port = intval($row['http_broadcast_port']);
        $sql_lb_user = _obf_0D13231A3D06231D2E0915212A173318050804182F1322($intro->option['sql_lb_user']);
        $sql_lb_pass = _obf_0D13231A3D06231D2E0915212A173318050804182F1322($intro->option['sql_lb_pass']);
        $data = [];
        $data['host'] = $server_ip;
        $data['db_port'] = 7999;
        $data['http_port'] = $http_broadcast_port;
        $data['db_user'] = $sql_lb_user;
        $data['db_pass'] = $sql_lb_pass;
        $data['db_name'] = 'xtream_iptvpro';
        $data['server_id'] = $server_id;
        $data['main_server_id'] = 1;
        $data['pconnect'] = '0';
        return _obf_0D2D0C3E2E35132A0B183B401A3D3B2C2314363E250122(json_encode($data));
    }
    public function DelForm()
    {
        global $intro;
        global $config;
        $id = intval($intro->input->get_post('id'));
        $sql2 = $intro->db->query('SELECT * FROM streaming_servers where id=' . $id . ';');
        $row2 = $intro->db->fetch_assoc($sql2);
        if( !is_array($row2) ) 
        {
            $intro->redirect($this->appname);
            exit();
        }
        @extract($row2);
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Delete Server: ' . $server_ip . '  ' . $server_name . ' ', 'danger');
        echo "<div class=\"btn-group\" role=\"group\" aria-label=\"Delete\">\n\t\t\t\t  \n\t\t\t\t  <a class=\"btn btn-danger p_del\" id=\"delete\" href=\"" . $this->base . '/Del?id=' . $id . "&NH=1&db=1\">\n\t\t\t\t\t<i class=\"icon-cancel-circled2\"></i> Final: Delete server From database\n\t\t\t\t  </a>\n\t\t\t\t  \n\t\t\t</div>\n\t\t\t\t\n\t\t\t\t<span id=\"spin\" class='icon-spin5'></span>";
        echo '<div id=\'result\'>';
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo "<script>\n\t\t\$('documnet').ready(function(){\n\t\t\t\$('#delete').click(function(e){\n\t\t\t\te.preventDefaults;\n\t\t\t\t\n\t\t\t\tif(!confirm('Are you sure? Delete this server?')) return false;\n\t\t\t\t\n\t\t\t\t\$('#spin').addClass('animate-spin');\n\t\t\t\t\$.get( \$(this).attr('href'), function( data ) {\n\t\t\t\t\t\$( \"#result\" ).html( data );\n\t\t\t\t\t\$('#spin').removeClass('animate-spin');\n\t\t\t\t});\n\t\t\t\treturn false;\n\t\t\t});\n\t\t\t\n\t\t});\n\t\t</script>";
    }
    public function Del()
    {
        global $intro;
        global $sess_admin;
        global $array;
        $id = intval($intro->input->get_post('id'));
        if( $this->admin['level'] == 1 ) 
        {
            $intro->db->query('delete from streaming_servers  WHERE id=' . $id . ' AND id!=1 AND can_delete=1');
        }
        else
        {
            exit( '<h1>Not authorized!</h1>' );
        }
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232("Delete success.  \n\t\t\t <a class=\"btn btn-success\"   href=\"" . $this->base . "/index\">\n\t\t\t\t\t <i class=\"icon-left-big\"></i> Go Back\n\t\t\t\t  </a>\n\t\t");
    }
    public function RestartStreams()
    {
        global $intro;
        global $sess_admin;
        global $array;
        $id = intval($intro->input->get_post('id'));
        if( $this->admin['level'] != 1 ) 
        {
            exit( '<h1>Not authorized!</h1>' );
        }
        $x = new XtreamApi('EmptyFunc');
        $allStreams = [];
        $result = $intro->db->query('SELECT stream_id FROM `streams_sys` WHERE server_id=' . $id . ';');
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            $allStreams[] = $myrow['stream_id'];
        }
        $stop = $x->Stop($allStreams);
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Stop Result: ' . $stop . ' ', 'info');
        $start = $x->Start($allStreams);
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Start Result: ' . $start . ' ', 'info');
    }
    public function KillCons()
    {
        global $intro;
        global $sess_admin;
        global $array;
        $id = $server_id = intval($intro->input->get_post('id'));
        if( $this->admin['level'] != 1 ) 
        {
            exit( '<h1>Not authorized!</h1>' );
        }
        $x = new XtreamApi('EmptyFunc');
        $pids = [];
        $result = $intro->db->query('SELECT pid FROM `user_activity_now` WHERE server_id=' . $id . ';');
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            $pids[] = $myrow['pid'];
        }
        $res = $x->KillPids($server_id, $pids);
        if( $res == 'success' ) 
        {
            $intro->db->query('DELETE FROM `user_activity_now` WHERE server_id=' . $id . ';');
        }
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Kill Result: ' . $res . ' ', 'info');
    }
    public function MainInstall()
    {
        global $intro;
        global $error;
        $server_ip = $intro->input->post('server_ip');
        $server_ip6 = $intro->input->post('server_ip6');
        $ssh_port = $intro->input->post('ssh_port');
        $ssh_password = $intro->input->post('ssh_password');
        $ssh_port = ($ssh_port == '' ? 22 : $ssh_port);
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="icon-cog-alt"></i> Main Server Installer', 'info');
        echo "\n\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . "/doMainInstall\" enctype=\"multipart/form-data\">\n\t\t<div class=\"table-responsive\">\n\t\t" . _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Warning! The installation will remove any database on server. Please backup first!!!', 'danger') . ("\n\t\t<table class=\"table table-bordered table-hover table-striped\">\n\t\t<tr>\n\t\t\t<td>Server IPv4 : <span style='color:#ff0000'>*</span></td>\n\t\t\t<td><input  type=\"text\" name=\"server_ip\" value=\"" . $server_ip . '" size="30"> ' . $this->error('server_ip') . "</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Server IPv6 : </td>\n\t\t\t<td><input  type=\"text\" name=\"server_ip6\" value=\"" . $server_ip6 . '" size="40"> ' . $this->error('server_ip6') . "</td>\n\t\t</tr>\n\n\t\t<tr>\n\t\t\t<td class='success'>SSH Port : <span style='color:#ff0000'>*</span></td>\n\t\t\t<td><input  type=\"text\" name=\"ssh_port\" value=\"" . $ssh_port . '" size="10"> ' . $this->error('ssh_port') . "</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td class='success'>SSH Username : <span style='color:#ff0000'>*</span></td>\n\t\t\t<td><input type=\"text\" name=\"ssh_user\" value=\"root\" size=\"20\"> " . $this->error('ssh_user') . "</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td class='success'>SSH Password : <span style='color:#ff0000'>*</span></td>\n\t\t\t<td><input type=\"text\" name=\"ssh_password\" value=\"\" size=\"20\"> " . $this->error('ssh_password') . "</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td class='success'>MySQL root Password : <span style='color:#ff0000'>*</span></td>\n\t\t\t<td><input type=\"text\" name=\"mysql_password\" value=\"\" size=\"20\"> " . $this->error('mysql_password') . "\n\t\t\tPlease remember your Mysql root password carefully.</td>\n\t\t</tr>");
        echo "\n\t\t<tr>\n\t\t\t<td></td>\n\t\t\t<td>\n\t\t\t\t<button type=\"submit\">\n\t\t\t\t\t<i class=\"icon-check\"></i> Start Install \n\t\t\t\t</button>\n\t\t\t</td>\n\t\t</tr>\n\t\t</table>\n\t\t</div>\n\t\t</form>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function doMainInstall()
    {
        global $intro;
        global $error;
        $server_ip = trim($intro->input->post('server_ip'));
        $server_ip6 = trim($intro->input->post('server_ip6'));
        $ssh_port = intval($intro->input->post('ssh_port'));
        $ssh_user = trim($intro->input->post('ssh_user'));
        $ssh_password = trim($intro->input->post('ssh_password'));
        $mysql_password = trim($intro->input->post('mysql_password'));
        if( $server_ip == '' || $ssh_port == 0 || $ssh_user == '' || $ssh_password == '' || $mysql_password == '' ) 
        {
            if( $server_ip == '' ) 
            {
                $error['server_ip'] = '<span class=\'error\'>Required!</span>';
            }
            if( $ssh_port == 0 ) 
            {
                $error['ssh_port'] = '<span class=\'error\'>Required!</span>';
            }
            if( $ssh_user == '' ) 
            {
                $error['ssh_user'] = '<span class=\'error\'>Required!</span>';
            }
            if( $ssh_password == '' ) 
            {
                $error['ssh_password'] = '<span class=\'error\'>Required!</span>';
            }
            if( $mysql_password == '' ) 
            {
                $error['mysql_password'] = '<span class=\'error\'>Required!</span>';
            }
            $this->MainInstall();
            exit();
        }
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22(' Start Main Server Installer ', 'success');
        $ssh = new Net_SSH2($server_ip, $ssh_port);
        if( !$ssh->login($ssh_user, $ssh_password) ) 
        {
            exit( _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<h4>Error: Login Failed. Please check SSH login info.</h4>', 'danger') );
        }
        $ssh->disconnect();
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<h4>Success.</h4>', 'success');
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function KeyToPass()
    {
        global $intro;
        global $error;
        $server_ip = $intro->input->post('server_ip');
        $server_ip6 = $intro->input->post('server_ip6');
        $ssh_port = $intro->input->post('ssh_port');
        $ssh_user = $intro->input->post('ssh_user');
        $ssh_password = $intro->input->post('ssh_password');
        $new_root_password = $intro->input->post('new_root_password');
        $ssh_key_phrase = $intro->input->post('ssh_key_phrase');
        $ssh_port = ($ssh_port == '' ? 22 : $ssh_port);
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="icon-cog-alt"></i>SSH Key to Password', 'info');
        echo "\n\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . "/doKeyToPass\" enctype=\"multipart/form-data\">\n\t\t<div class=\"table-responsive\">\n\t\t<table class=\"table table-bordered table-hover table-striped\">\n\t\t<tr>\n\t\t\t<td>Server IPv4 : <span style='color:#ff0000'>*</span></td>\n\t\t\t<td><input  type=\"text\" name=\"server_ip\" value=\"" . $server_ip . '" size="30"> ' . $this->error('server_ip') . "</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Server IPv6 : </td>\n\t\t\t<td><input  type=\"text\" name=\"server_ip6\" value=\"" . $server_ip6 . '" size="40"> ' . $this->error('server_ip6') . "</td>\n\t\t</tr>\n\n\t\t<tr>\n\t\t\t<td class='success'>SSH Port : <span style='color:#ff0000'>*</span></td>\n\t\t\t<td><input  type=\"text\" name=\"ssh_port\" value=\"" . $ssh_port . '" size="10"> ' . $this->error('ssh_port') . "</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td class='success'>SSH Username : <span style='color:#ff0000'>*</span></td>\n\t\t\t<td><input type=\"text\" name=\"ssh_user\" value=\"" . $ssh_user . '" size="20"> ' . $this->error('ssh_user') . "</td>\n\t\t</tr><!--\n\t\t<tr>\n\t\t\t<td class='success'>SSH Username Password : </td>\n\t\t\t<td><input type=\"text\" name=\"ssh_password\" value=\"" . $ssh_password . '" size="20"> ' . $this->error('ssh_password') . "</td>\n\t\t</tr>-->\n\t\t<tr>\n\t\t\t<td class='success'>New root Password : <span style='color:#ff0000'>*</span></td>\n\t\t\t<td><input type=\"text\" name=\"new_root_password\" value=\"" . $new_root_password . '" size="20"> ' . $this->error('new_root_password') . "</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td class='success'>SSH Key : <span style='color:#ff0000'>*</span></td>\n\t\t\t<td><input type=\"file\" name=\"key_file\"/> " . $this->error('key_file') . "</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td class='success'>SSH Key Phrase :</td>\n\t\t\t<td><input type=\"text\" name=\"ssh_key_phrase\" value=\"" . $ssh_key_phrase . '" size="20"> ' . $this->error('ssh_key_phrase') . "</td>\n\t\t</tr>";
        echo "\n\t\t<tr>\n\t\t\t<td></td>\n\t\t\t<td>\n\t\t\t\t<button type=\"submit\">\n\t\t\t\t\t<i class=\"icon-check\"></i> Enable root login\n\t\t\t\t</button>\n\t\t\t</td>\n\t\t</tr>\n\t\t</table>\n\t\t</div>\n\t\t</form>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function doKeyToPass()
    {
        global $intro;
        global $error;
        $server_ip = trim($intro->input->post('server_ip'));
        $server_ip6 = trim($intro->input->post('server_ip6'));
        $ssh_port = intval($intro->input->post('ssh_port'));
        $ssh_user = trim($intro->input->post('ssh_user'));
        $ssh_password = trim($intro->input->post('ssh_password'));
        $ssh_key_phrase = trim($intro->input->post('ssh_key_phrase'));
        $new_root_password = trim($intro->input->post('new_root_password'));
        if( $ssh_port == 0 || $ssh_user == '' || !is_uploaded_file($_FILES['key_file']['tmp_name']) || $server_ip == '' || $new_root_password == '' || strlen($new_root_password) < 8 ) 
        {
            if( $ssh_port == 0 ) 
            {
                $error['ssh_port'] = _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Enter SSH Port!', 'danger');
            }
            if( $ssh_user == '' ) 
            {
                $error['ssh_user'] = _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Enter SSH User!', 'danger');
            }
            if( $server_ip == '' ) 
            {
                $error['server_ip'] = _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Enter server IP!', 'danger');
            }
            if( $new_root_password == '' ) 
            {
                $error['new_root_password'] = _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Enter New root Password!', 'danger');
            }
            if( strlen($new_root_password) < 8 ) 
            {
                $error['new_root_password'] = _obf_0D3D40321528110F062A0B0321102712170C15030F2232('New root Password Must be 8 chars or more AND must be Strong Password!', 'danger');
            }
            if( !is_uploaded_file($_FILES['key_file']['tmp_name']) ) 
            {
                $error['key_file'] = _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Please Upload SSH Key!', 'danger');
            }
            $this->KeyToPass();
            exit();
        }
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22(' Set Password for root ', 'success');
        $key = new Crypt_RSA();
        if( $ssh_key_phrase != '' ) 
        {
            $key->setPassword($ssh_key_phrase);
        }
        $key->loadKey(file_get_contents($_FILES['key_file']['tmp_name']));
        $ssh = new Net_SSH2($server_ip);
        if( !$ssh->login($ssh_user, $key) ) 
        {
            exit( _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<h4>Error: Key Login Failed. Please check SSH Key/user info.</h4>', 'danger') );
        }
        $ssh->exec(' echo -e "Y" | apt install -y sudo ');
        $ssh->exec(' sudo  sed -i \'s/#PermitRootLogin prohibit-password*/PermitRootLogin yes/\' /etc/ssh/sshd_config && sudo  sed -i \'s/#PasswordAuthentication yes*/PasswordAuthentication yes/\' /etc/ssh/sshd_config');
        $ssh->exec(' sudo  echo \'\' > /etc/motd.head');
        $ssh->exec(' sudo service ssh reload');
        $pwd_change = $ssh->exec(' sudo echo -e "' . $new_root_password . "\n" . $new_root_password . '" | sudo passwd root');
        if( preg_match('/successfully/i', $pwd_change) ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<h4>Success. New root Password = ' . $new_root_password . ' </h4>', 'success');
        }
        else
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<h4>Failed.</h4>', 'danger');
        }
        echo '<textarea style="width:90%;height:100px">' . $pwd_change . '</textarea><hr>';
        $ssh->disconnect();
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
}
