<?php
/**
 * Build EPG Mapping from M3U
 * Run this to create stream_id -> tvg_id mapping
 */

require_once __DIR__ . '/includes/Config.php';

$pdo = new PDO(
    "mysql:host={$config['db']['hostname']};dbname={$config['db']['database']};charset=utf8",
    $config['db']['username'],
    $config['db']['password']
);

// Get panel settings
$stmt = $pdo->query("SELECT setting_key, setting_value FROM panel_settings");
$settings = [];
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

$panel_url = $settings['panel_url'] ?? '';
$source_user = $settings['panel_username'] ?? '';
$source_pass = $settings['panel_password'] ?? '';
$parsed = parse_url($panel_url);
$host = $parsed['host'];

// Fetch M3U
$m3u_url = 'http://' . $host . ':80/get.php?username=' . urlencode($source_user)
         . '&password=' . urlencode($source_pass) . '&type=m3u_plus&output=ts';

echo "Fetching M3U from: $m3u_url\n";

$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $m3u_url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 120,
    CURLOPT_SSL_VERIFYPEER => false
]);
$m3u = curl_exec($ch);
curl_close($ch);

if (!$m3u) {
    die("Failed to fetch M3U\n");
}

// Parse M3U
$mapping = [];
$lines = explode("\n", $m3u);
$tvg_id = '';

foreach ($lines as $line) {
    if (strpos($line, '#EXTINF') === 0) {
        if (preg_match('/tvg-id="([^"]*)"/', $line, $m)) {
            $tvg_id = $m[1];
        }
    } elseif (strpos($line, 'http') === 0 && !empty($tvg_id)) {
        if (preg_match('/\/(\d+)\.(ts|m3u8)/', $line, $m)) {
            $mapping[$m[1]] = $tvg_id;
        }
        $tvg_id = '';
    }
}

echo "Found " . count($mapping) . " stream mappings\n";

// Save mapping
@mkdir(__DIR__ . '/cache', 0755, true);
file_put_contents(__DIR__ . '/cache/epg_mapping.json', json_encode($mapping));

echo "Mapping saved to cache/epg_mapping.json\n";

// Also fetch and cache XMLTV
echo "Fetching XMLTV...\n";
$xmltv_url = 'http://' . $host . ':80/xmltv.php?username=' . urlencode($source_user)
           . '&password=' . urlencode($source_pass);

$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $xmltv_url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 180,
    CURLOPT_SSL_VERIFYPEER => false
]);
$xml = curl_exec($ch);
curl_close($ch);

if ($xml) {
    file_put_contents(__DIR__ . '/cache/epg.xml', $xml);
    echo "XMLTV saved to cache/epg.xml (" . strlen($xml) . " bytes)\n";
} else {
    echo "Failed to fetch XMLTV\n";
}

echo "Done!\n";
?>
