<?php
// Diagnostic tool for token issues

header('Content-Type: application/json');

$XOR_KEY = "KvuZRm365wk5Sz&Xy.Zx";

function xor_decrypt($encrypted, $key) {
    $keyLen = strlen($key);
    $decrypted = '';
    for ($i = 0; $i < strlen($encrypted); $i++) {
        $decrypted .= chr(ord($encrypted[$i]) ^ ord($key[$i % $keyLen]));
    }
    return $decrypted;
}

// Get raw POST data
$raw_input = file_get_contents('php://input');

// Try to extract json parameter
if (preg_match('/json=([^&]+)/', $raw_input, $matches)) {
    $encrypted_data = urldecode($matches[1]);
    $decrypted = xor_decrypt($encrypted_data, $XOR_KEY);
    $json_data = json_decode($decrypted, true);

    $response = [
        'diagnostic' => true,
        'received_data' => $json_data,
        'token_info' => []
    ];

    if (isset($json_data['token'])) {
        $token = $json_data['token'];
        $response['token_info'] = [
            'length' => strlen($token),
            'first_50_chars' => substr($token, 0, 50),
            'has_escaped_slash' => strpos($token, '\/') !== false,
            'has_forward_slash' => strpos($token, '/') !== false,
            'md5_prefix' => substr($token, 0, 32),
        ];

        // Check database
        require_once('../includes/Config.php');
        $link = mysqli_connect(
            $config['db']['hostname'],
            $config['db']['username'],
            $config['db']['password'],
            $config['db']['database']
        );

        if ($link) {
            $safe_token = mysqli_real_escape_string($link, $token);
            $result = mysqli_query($link, "SELECT user_id, FROM_UNIXTIME(created) as created, FROM_UNIXTIME(expires) as expires FROM user_tokens WHERE token = '$safe_token'");

            if ($result && mysqli_num_rows($result) > 0) {
                $response['token_info']['database_status'] = 'found';
                $response['token_info']['token_data'] = mysqli_fetch_assoc($result);
            } else {
                $response['token_info']['database_status'] = 'not_found';

                // Try to find similar tokens
                $prefix = substr($token, 0, 32);
                $result2 = mysqli_query($link, "SELECT token, user_id FROM user_tokens WHERE token LIKE '$prefix%' LIMIT 5");
                if ($result2 && mysqli_num_rows($result2) > 0) {
                    $similar = [];
                    while ($row = mysqli_fetch_assoc($result2)) {
                        $similar[] = [
                            'user_id' => $row['user_id'],
                            'token_preview' => substr($row['token'], 0, 50) . '...'
                        ];
                    }
                    $response['token_info']['similar_tokens'] = $similar;
                }
            }
            mysqli_close($link);
        }
    }

    echo json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
} else {
    echo json_encode(['error' => 'No json parameter found']);
}
