<?php
/**
 * M3U Playlist Generator with EPG Support
 * Verifies user locally, then fetches M3U from source using master credentials
 *
 * Usage: get.php?username=USER&password=PASS&type=m3u_plus&output=ts
 */

// Get request parameters
$username = isset($_GET['username']) ? $_GET['username'] : '';
$password = isset($_GET['password']) ? $_GET['password'] : '';
$type = isset($_GET['type']) ? $_GET['type'] : 'm3u_plus';
$output = isset($_GET['output']) ? $_GET['output'] : 'ts';

// Load config
require_once __DIR__ . '/includes/Config.php';

try {
    $pdo = new PDO(
        "mysql:host={$config['db']['hostname']};dbname={$config['db']['database']};charset=utf8",
        $config['db']['username'],
        $config['db']['password']
    );
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Verify user exists locally
    $stmt = $pdo->prepare("SELECT id, username, exp_date FROM users WHERE username = ? AND password = ? LIMIT 1");
    $stmt->execute([$username, $password]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        header('HTTP/1.1 403 Forbidden');
        echo "Invalid credentials";
        exit;
    }

    // Check if expired
    if ($user['exp_date'] && $user['exp_date'] < time()) {
        header('HTTP/1.1 403 Forbidden');
        echo "Account expired";
        exit;
    }

    // Get panel settings
    $stmt = $pdo->query("SELECT setting_key, setting_value FROM panel_settings");
    $settings = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $settings[$row['setting_key']] = $row['setting_value'];
    }

    // Get source server URL and credentials
    $panel_url = isset($settings['panel_url']) ? $settings['panel_url'] : '';
    $source_username = isset($settings['panel_username']) ? $settings['panel_username'] : '';
    $source_password = isset($settings['panel_password']) ? $settings['panel_password'] : '';

    // Build source M3U URL with MASTER credentials
    $m3u_url = $panel_url . '/get.php?username=' . urlencode($source_username)
             . '&password=' . urlencode($source_password)
             . '&type=' . urlencode($type)
             . '&output=' . urlencode($output);

    // Fetch M3U from source
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $m3u_url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_TIMEOUT => 120,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_SSL_VERIFYHOST => false,
        CURLOPT_USERAGENT => 'IPTV Panel M3U Fetcher'
    ]);

    $m3u_content = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);

    if ($http_code != 200 || !$m3u_content) {
        header('HTTP/1.1 500 Internal Server Error');
        echo "Error fetching M3U: " . ($error ?: "HTTP $http_code");
        exit;
    }

    // Get current server URL for EPG
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'];
    $epg_url = $protocol . '://' . $host . '/iptv/xmltv.php?username=' . urlencode($username) . '&password=' . urlencode($password);

    // Set headers
    header('Content-Type: audio/mpegurl');
    header('Content-Disposition: attachment; filename="' . $username . '.m3u"');
    header('Access-Control-Allow-Origin: *');

    // Replace source credentials with user credentials in stream URLs
    $m3u_content = str_replace(
        '/live/' . $source_username . '/' . $source_password . '/',
        '/live/' . $username . '/' . $password . '/',
        $m3u_content
    );
    $m3u_content = str_replace(
        '/movie/' . $source_username . '/' . $source_password . '/',
        '/movie/' . $username . '/' . $password . '/',
        $m3u_content
    );
    $m3u_content = str_replace(
        '/series/' . $source_username . '/' . $source_password . '/',
        '/series/' . $username . '/' . $password . '/',
        $m3u_content
    );

    // Add EPG URL to header if not present
    if (strpos($m3u_content, 'url-tvg=') === false) {
        $m3u_content = str_replace('#EXTM3U', '#EXTM3U url-tvg="' . $epg_url . '"', $m3u_content);
    }

    echo $m3u_content;

} catch (Exception $e) {
    header('HTTP/1.1 500 Internal Server Error');
    echo "Error: " . $e->getMessage();
}
?>
