<?php 
class IntroCurl
{
    public $url = '';
    public $post = [];
    public $timeout = 5;
    public function __construct($url = '')
    {
        $this->url = $url;
    }
    public function getM3uVOD()
    {
        $this->post = [
            'mode' => 'm3u_vod', 
            'u' => 'm3u_vod', 
            'p' => 'm3u_vod', 
            'e' => 'expire', 
            'url' => $this->url
        ];
        return $this->runCurl();
    }
    public function runCurl()
    {
        global $intro;
        global $array;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, str_replace('|', '/', $this->url));
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $this->post);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $this->timeout);
        curl_setopt($ch, CURLOPT_TIMEOUT, $this->timeout);
        $output = curl_exec($ch);
        $err = curl_error($ch);
        if( $err ) 
        {
            exit( '<h3>ERROR: ' . $err . '</h3>' );
        }
        curl_close($ch);
        return $output;
    }
    public function set($name, $value)
    {
        $this->$name = $value;
    }
    public function post($api, $post)
    {
        if( $api == '' || $api == null ) 
        {
            $api = $this->url;
        }
        if( function_exists('curl_version') ) 
        {
            $curl = curl_init();
            curl_setopt($curl, CURLOPT_URL, $api);
            curl_setopt($curl, CURLOPT_TIMEOUT, $this->timeout);
            curl_setopt($curl, CURLOPT_POST, 1);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $post);
            $response = curl_exec($curl);
            $err = curl_error($curl);
            curl_close($curl);
            if( $err != '' ) 
            {
                return $err;
            }
        }
        else
        {
            error_clear_last();
            $context = [
                'http' => [
                    'method' => 'POST', 
                    'header' => 'Content-type: application/x-www-form-urlencoded', 
                    'timeout' => $this->timeout, 
                    'content' => http_build_query($post)
                ]
            ];
            $response = file_get_contents($api, false, stream_context_create($context));
            $error = error_get_last();
            if( isset($error['message']) && $error['message'] != '' ) 
            {
                return $error['message'];
            }
        }
        return $response;
    }
}
