<?php 
class IntroPerms
{
    public $adminid = 0;
    public $period = 0;
    public $userid = 0;
    public $num = 0;
    public $cost = 0;
    public $ResellerCost = 0;
    public $FatherCost = 0;
    public $package = 0;
    public $error = '';
    public $admin = [];
    public $is_trial = 0;
    public $trial_credits = 0;
    public $trial_duration = 0;
    public $trial_duration_in = '';
    public $balance = 0;
    public $is_official = 0;
    public $official_credits = 0;
    public $official_duration = 0;
    public $official_duration_in = '';
    public function __construct($method, $admin, $num = 1, $period = 0, $package = 0)
    {
        $this->admin = $admin;
        $this->num = $num;
        $this->period = $period;
        $this->package = $package;
        $this->adminid = intval($this->admin['adminid']);
        $this->balance = _obf_0D3B1A30163C23381912245B381E2D3F0B0B340C070901($this->adminid);
        if( $this->admin['member_group_id'] > 0 && $this->package > 0 ) 
        {
            $pkg = _obf_0D0E122A21280A14271F3B1D1727291E290A0A2A092E11($this->package, '', 0, $this->admin['packages']);
            if( !$pkg ) 
            {
                return null;
            }
            $this->is_trial = $pkg['is_trial'];
            $this->trial_credits = $pkg['trial_credits'];
            $this->trial_duration = $pkg['trial_duration'];
            $this->trial_duration_in = $pkg['trial_duration_in'];
            $this->is_official = $pkg['is_official'];
            $this->official_credits = $pkg['official_credits'];
            $this->official_duration = $pkg['official_duration'];
            $this->official_duration_in = $pkg['official_duration_in'];
        }
        $this->$method();
    }
    public function CheckBalance()
    {
        global $intro;
        global $array;
        $adminid = intval($this->admin['adminid']);
        $father = intval($this->admin['father']);
        $level = intval($this->admin['level']);
        if( $adminid == 0 ) 
        {
            exit( 'error: unknow resel ID!!!.' );
        }
        if( $this->admin['member_group_id'] > 0 ) 
        {
            if( $this->balance <= 0 ) 
            {
                $this->error = 'Error 501: Insufficient balance! for Reseller (' . $this->admin['admin_name'] . '). Please add credit.';
            }
            if( $this->is_official == 1 && $this->balance < $this->official_credits ) 
            {
                $this->error = 'Error 502: Insufficient balance! for Reseller (' . $this->admin['admin_name'] . ') Balance (' . $this->balance . '). Please add credit. Package credit = ' . $this->official_credits;
            }
        }
        if( $level == 1 ) 
        {
            return null;
        }
        if( intval($this->admin['postpaid']) == 1 ) 
        {
            return null;
        }
        if( $level == 7 ) 
        {
            $balanceF = _obf_0D3B1A30163C23381912245B381E2D3F0B0B340C070901($father);
            $fatherRow = $intro->auth->admin_data($father);
            if( $balanceF <= 0 && intval($fatherRow['postpaid']) == 0 && $intro->option['CreditSystem'] != 'restrict' ) 
            {
                echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Error 610: You can\'t add now. Please contact your Admin.', 'danger');
                exit();
            }
        }
        $balance = _obf_0D3B1A30163C23381912245B381E2D3F0B0B340C070901($this->admin['adminid']);
        if( $balance <= 0 && intval($this->admin['postpaid']) == 0 ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Insufficient balance! for Reseller (' . $this->admin['admin_name'] . '). Please add credit.', 'danger');
            exit();
        }
    }
    public function CheckCost()
    {
        global $intro;
        global $array;
        $adminid = intval($this->admin['adminid']);
        $father = intval($this->admin['father']);
        $level = intval($this->admin['level']);
        $period = intval($this->period);
        if( $adminid == 0 ) 
        {
            exit( 'error: unknow resel ID!!!.' );
        }
        if( $this->admin['member_group_id'] > 0 ) 
        {
            if( $this->balance <= 0 ) 
            {
                $this->error = 'Error 501: Insufficient balance! for Reseller (' . $this->admin['admin_name'] . '). Please add credit.';
            }
            if( $this->is_official == 1 && $this->balance < $this->official_credits ) 
            {
                $this->error = 'Error 502: Insufficient balance! for Reseller (' . $this->admin['admin_name'] . '). Please add credit.';
                return null;
            }
            $this->ResellerCost = $this->official_credits;
            $this->TotalCost = $this->num * $this->ResellerCost;
            $this->cost = $this->ResellerCost;
        }
        $loged_admin = $intro->auth->sess_admin();
        $loged_level = intval($loged_admin['level']);
        if( in_array($period, $array['free']) ) 
        {
            return null;
        }
        $this->ResellerCost = floatval($this->admin['cost_' . $period]);
        if( $level == 7 ) 
        {
            $balanceF = _obf_0D3B1A30163C23381912245B381E2D3F0B0B340C070901($father);
            $fatherRow = $intro->auth->admin_data($father);
            if( $balanceF <= 0 && intval($fatherRow['postpaid']) == 0 && $intro->option['CreditSystem'] != 'restrict' ) 
            {
                $this->error = 'Error 610: You can\'t add now. Please contact your Admin.';
                return null;
            }
            $father_name = $fatherRow['admin_name'];
            $father_cost = floatval($fatherRow['cost_' . $period]);
            if( $father_cost <= 0 ) 
            {
                $this->error = 'Error:710 unable to get total cost of (' . $period . ' Month) for reseller <u>' . $father_name . '</u>, please contact system admin.';
                return null;
            }
            if( $this->ResellerCost < $father_cost ) 
            {
                $this->error = 'Error:720 contact your admin <u>' . $father_name . '</u>, to fix the cost for (' . $period . ' Month).';
                return null;
            }
            $this->FatherCost = $this->num * $father_cost;
            if( $balanceF < $this->FatherCost && intval($fatherRow['postpaid']) == 0 && $intro->option['CreditSystem'] != 'restrict' ) 
            {
                $this->error = 'Error 610: You can\'t add now. Please contact your Admin.';
            }
        }
        $balance = _obf_0D3B1A30163C23381912245B381E2D3F0B0B340C070901($adminid);
        if( $balance <= 0 && intval($this->admin['postpaid']) == 0 ) 
        {
            $this->error = 'Insufficient balance! for Reseller (' . $this->admin['admin_name'] . '). Please add credit.';
        }
        if( intval($this->admin['cost_' . $period . '_enabled']) == 0 ) 
        {
            $this->error = 'Error: cost of (' . $period . ' Month) is disabled  for reseller <u>' . $this->admin['admin_name'] . '</u>.';
        }
        if( $this->ResellerCost <= 0 ) 
        {
            $this->error = 'Error: cost of (' . $period . ' Month) is <b>Zero</b> for reseller <u>' . $this->admin['admin_name'] . '</u>, please set the cost amount.';
        }
        $this->TotalCost = $this->num * $this->ResellerCost;
        if( $balance < $this->TotalCost && intval($this->admin['postpaid']) == 0 ) 
        {
            $this->error = 'Insufficient balance for (' . $this->admin['admin_name'] . ') Please add credit.';
        }
        $this->cost = $this->ResellerCost;
    }
    public function set($name, $value)
    {
        $this->$name = $value;
    }
}
