<?php
// SOLUSTV TEAM

class Session
{
    private $flashdata = NULL;
    private $flashdata_varname = NULL;
    private $session_lifetime = NULL;
    private $link = NULL;
    private $lock_timeout = NULL;
    private $lock_to_ip = NULL;
    private $lock_to_user_agent = NULL;
    private $table_name = NULL;
    public function __construct($link, $security_code, $session_lifetime = "", $lock_to_user_agent = true, $lock_to_ip = false, $gc_probability = "", $gc_divisor = "", $table_name = "session_data", $lock_timeout = 60)
    {
        if ($link instanceof MySQLi && $link->connect_error === NULL) {
            $this->link = $link;
            if ($session_lifetime != "" && is_integer($session_lifetime)) {
            }
            if ($gc_probability != "" && is_integer($gc_probability)) {
                ini_set("session.gc_probability", $gc_probability);
            }
            if ($gc_divisor != "" && is_integer($gc_divisor)) {
                ini_set("session.gc_divisor", $gc_divisor);
            }
            $this->session_lifetime = ini_get("session.gc_maxlifetime");
            $this->security_code = $security_code;
            $this->lock_to_user_agent = $lock_to_user_agent;
            $this->lock_to_ip = $lock_to_ip;
            $this->table_name = PREFIX . "_" . $table_name;
            $this->lock_timeout = $lock_timeout;
            session_set_save_handler(array($this, "open"), array($this, "close"), array($this, "read"), array($this, "write"), array($this, "destroy"), array($this, "gc"));
            session_start();
            $this->flashdata_varname = "_zebra_session_flashdata_ec3asbuiad";
            $this->flashdata = array();
            if (isset($_SESSION[$this->flashdata_varname])) {
                $this->flashdata = unserialize($_SESSION[$this->flashdata_varname]);
                unset($_SESSION[$this->flashdata_varname]);
            }
            register_shutdown_function(array($this, "_manage_flashdata"));
        } else {
            exit("Error: No Connection to SQL Server.");
        }
    }
    public function close()
    {
        if ($this->_mysql_query("SELECT RELEASE_LOCK(\"" . $this->session_lock . "\")")) {
            return true;
        }
    }
    public function destroy($session_id)
    {
        $this->_mysql_query("\n\n            DELETE FROM\n                " . $this->table_name . "\n            WHERE\n                session_id = \"" . $this->_mysql_real_escape_string($session_id) . "\"\n\n        ");
        return $this->_mysql_affected_rows() !== -1;
    }
    public function gc()
    {
        $this->_mysql_query("\n\n            DELETE FROM\n                " . $this->table_name . "\n            WHERE\n                session_expire < \"" . $this->_mysql_real_escape_string(time()) . "\"\n\n        ");
    }
    public function get_active_sessions()
    {
        $this->gc();
        $result = mysqli_fetch_assoc($this->_mysql_query("\n\n            SELECT\n                COUNT(session_id) as count\n            FROM " . $this->table_name . "\n\n        "));
        return $result["count"];
    }
    public function get_settings()
    {
        $gc_maxlifetime = ini_get("session.gc_maxlifetime");
        $gc_probability = ini_get("session.gc_probability");
        $gc_divisor = ini_get("session.gc_divisor");
        return array("session.gc_maxlifetime" => $gc_maxlifetime . " seconds (" . round($gc_maxlifetime / 60) . " minutes)", "session.gc_probability" => $gc_probability, "session.gc_divisor" => $gc_divisor, "probability" => $gc_probability / $gc_divisor * 100 . "%");
    }
    public function open()
    {
        return true;
    }
    public function read($session_id)
    {
        $this->session_lock = $this->_mysql_real_escape_string("session_" . $session_id);
        $result = $this->_mysql_query("SELECT GET_LOCK(\"" . $this->session_lock . "\", " . $this->_mysql_real_escape_string($this->lock_timeout) . ")");
        if (!$result || mysqli_num_rows($result) != 1 || !($row = mysqli_fetch_array($result)) || $row[0] != 1) {
            exit("SESS:Connection lost!");
        }
        $hash = "";
        if ($this->lock_to_user_agent && isset($_SERVER["HTTP_USER_AGENT"])) {
            $hash .= $_SERVER["HTTP_USER_AGENT"];
        }
        if ($this->lock_to_ip) {
            $hash .= $this->ip();
        }
        $hash .= $this->security_code;
        $result = $this->_mysql_query("\n\n            SELECT\n                session_data\n            FROM\n                " . $this->table_name . "\n            WHERE\n                session_id = \"" . $this->_mysql_real_escape_string($session_id) . "\" AND\n                session_expire > \"" . time() . "\" AND\n                hash = \"" . $this->_mysql_real_escape_string(md5($hash)) . "\"\n            LIMIT 1\n\n        ");
        if ($result && 0 < mysqli_num_rows($result)) {
            $fields = mysqli_fetch_assoc($result);
            return $fields["session_data"];
        }
        return "";
    }
    public function regenerate_id()
    {
        session_regenerate_id(true);
    }
    public function set_flashdata($name, $value)
    {
        $_SESSION[$name] = $value;
        $this->flashdata[$name] = 0;
    }
    public function stop()
    {
        if (ini_get("session.use_cookies")) {
            $params = session_get_cookie_params();
            setcookie(session_name(), "", time() - 42000, $params["path"], $params["domain"], $params["secure"], $params["httponly"]);
        }
        session_unset();
        session_destroy();
    }
    public function write($session_id, $session_data)
    {
        $ip = $this->ip();
        $page = isset($_SERVER["PATH_INFO"]) ? $_SERVER["PATH_INFO"] : "";
        $page .= isset($_SERVER["QUERY_STRING"]) ? $_SERVER["QUERY_STRING"] : "";
        $result = $this->_mysql_query("\n\n            INSERT INTO\n                " . $this->table_name . " (\n                    session_id,\n                    hash,\n                    session_data,\n                    session_expire,\n                    uagent,\n                    page,\n                    ip\n                )\n            VALUES (\n                \"" . $this->_mysql_real_escape_string($session_id) . "\",\n                \"" . $this->_mysql_real_escape_string(md5(($this->lock_to_user_agent && isset($_SERVER["HTTP_USER_AGENT"]) ? $_SERVER["HTTP_USER_AGENT"] : "") . ($this->lock_to_ip ? $ip : "") . $this->security_code)) . "\",\n                \"" . $this->_mysql_real_escape_string($session_data) . "\",\n                \"" . $this->_mysql_real_escape_string(time() + $this->session_lifetime) . "\",\n                \"" . $this->_mysql_real_escape_string($_SERVER["HTTP_USER_AGENT"]) . "\",\n                \"" . $this->_mysql_real_escape_string($page) . "\",\n                \"" . $this->_mysql_real_escape_string($ip) . "\"\n            )\n            ON DUPLICATE KEY UPDATE\n                session_data = \"" . $this->_mysql_real_escape_string($session_data) . "\",\n                session_expire = \"" . $this->_mysql_real_escape_string(time() + $this->session_lifetime) . "\",\n                uagent = \"" . $this->_mysql_real_escape_string($_SERVER["HTTP_USER_AGENT"]) . "\",\n                page = \"" . $this->_mysql_real_escape_string($page) . "\",\n                ip = \"" . $this->_mysql_real_escape_string($ip) . "\"\n\n        ");
        return $result ? true : false;
    }
    public function ip()
    {
        if (!empty($_SERVER["HTTP_CLIENT_IP"])) {
            $ip = $_SERVER["HTTP_CLIENT_IP"];
        } else {
            if (!empty($_SERVER["HTTP_X_FORWARDED_FOR"])) {
                $ip = $_SERVER["HTTP_X_FORWARDED_FOR"];
            } else {
                $ip = $_SERVER["REMOTE_ADDR"];
            }
        }
        if (strpos($ip, ",") !== false) {
            $x = explode(",", $ip);
            $ip = trim($x[0]);
        }
        return $ip;
    }
    public function _manage_flashdata()
    {
        if (!empty($this->flashdata)) {
            foreach ($this->flashdata as $variable => $counter) {
                $this->flashdata[$variable]++;
                if (1 < $this->flashdata[$variable]) {
                    unset($_SESSION[$variable]);
                    unset($this->flashdata[$variable]);
                }
            }
            if (!empty($this->flashdata)) {
                $_SESSION[$this->flashdata_varname] = serialize($this->flashdata);
            }
        }
    }
    private function _mysql_affected_rows()
    {
        return mysqli_affected_rows($this->link);
    }
    private function _mysql_error()
    {
        return "SESS:ERR: " . mysqli_error($this->link);
    }
    private function _mysql_query($query)
    {
        $result = mysqli_query($this->link, $query) or exit($this->_mysql_error());
        return $result;
    }
    private function _mysql_real_escape_string($string)
    {
        return mysqli_real_escape_string($this->link, $string);
    }
}

?>