<?php 
class StreamsEdit
{
    public $base = '';
    public $servers = [];
    public $seen_id = 0;
    public $type = 0;
    public function __construct($base, $type = 0)
    {
        $this->base = $base;
        $this->type = $type;
    }
    public function Restart()
    {
        global $intro;
        global $sess_admin;
        $streams = $streams = intval($intro->input->get_post('id'));
        $mode = trim($intro->input->get_post('mode'));
        $x = new XtreamApi('EmptyFunc');
        if( $mode == '' ) 
        {
            $x->Restart($streams);
        }
        else
        {
            $x->StopOrStart($streams, $mode);
        }
    }
    public function getStreamStatus()
    {
        global $intro;
        global $array;
        $id = intval($intro->input->get_post('id'));
        $cur_host = [];
        $cur_host['host'] = '-';
        $elapsed_time = $cur_host['host'];
        $result = $intro->db->query('SELECT * from streams s  LEFT OUTER JOIN `streams_sys` sys ON s.id=sys.stream_id ' . ('  WHERE s.type IN (1,3) AND s.id=' . $id));
        $row = $intro->db->fetch_assoc($result);
        @extract($row);
        if( $current_source != '' ) 
        {
            $cur_host = parse_url($current_source);
        }
        if( $stream_info != '' ) 
        {
            $stream_info = json_decode($stream_info);
            $start_time = round($stream_info->codecs->video->start_time, 2);
            if( $stream_status == 0 ) 
            {
                $txt_status = '<icon class=icon-globe style=color:green></icon>';
                $elapsed_time = _obf_0D10361F073B102D294032060E21400727331210083132($stream_started);
            }
            else if( $stream_status == 1 ) 
            {
                $txt_status = '<icon class=icon-globe style=color:#a8a8b7></icon>';
            }
            else
            {
                $txt_status = 'ERROR';
            }
        }
        $ar = [];
        $ar['cur_host_' . $id] = $cur_host['host'];
        $ar['live_' . $id] = (($on_demand == 1 ? 'OnDemand' : 'Live')) . (' ' . $txt_status);
        $ar['elapsed_time_' . $id] = $elapsed_time;
        header('Content-Type: application/json');
        echo json_encode($ar);
    }
    public function TableStart($params = '')
    {
        global $intro;
        global $array;
        echo "\n\t\t<table class=\"DataTables table table-bordered table-hover table-striped table-condensed\" id='table-1'>\n        <thead>\n\t    <tr>\n\t\t\t<th>#</th>\n\t\t\t<th> </th>\n\t\t\t<th>ID " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('id', 'index', $params) . "</th>\n\t\t\t<th>Channel Names</th>\n\t\t\t<th>Logo</th>\n\t\t\t<th>Time</th>\n\t\t\t<th>Server</th>\n\t\t\t<th>Cur Source</th>\n\t\t\t<th>Users</th>\n\t\t\t<th> </th>\n\t\t\t<th>Codec</th>\n\t\t\t<th>" . $intro->lang['options'] . "</th>\n\t    </tr>\n\t\t</thead>\n\t\t\n\t\t<tbody>";
    }
    public function getCurSourceNum($stream_source, $cur)
    {
        $stream_source = json_decode($stream_source, true);
        $i = 0;
        foreach( $stream_source as $src ) 
        {
            $i++;
            if( $cur == $src ) 
            {
                return '[' . $i . ']';
            }
        }
    }
    public function Row($row, $i)
    {
        global $intro;
        global $array;
        global $sess_admin;
        global $options;
        $cur_host = [];
        $cur_host['host'] = '-';
        $elapsed_time = $cur_host['host'];
        $txt_status = '<icon class="icon-cancel-circled" style=\'color:red;\'></icon>';
        if( !is_array($row) ) 
        {
            return 'error stream not found!';
        }
        extract($row);
        $id = intval($row['id']);
        $tot = (isset($row['tot']) ? $row['tot'] : '');
        $stream_display_name = trim($row['stream_display_name']);
        if( $current_source != '' ) 
        {
            $cur_host = parse_url($current_source);
        }
        $stream_info = json_decode($stream_info, true);
        if( isset($stream_info['codecs']['video']['start_time']) ) 
        {
            $start_time = round($stream_info['codecs']['video']['start_time'], 2);
        }
        if( !isset($stream_info['codecs']['video']['codec_name']) ) 
        {
            $stream_info['codecs']['video']['codec_name'] = '-';
        }
        if( !isset($stream_info['codecs']['audio']['codec_name']) ) 
        {
            $stream_info['codecs']['audio']['codec_name'] = '-';
        }
        if( !isset($stream_info['codecs']['video']['width']) ) 
        {
            $stream_info['codecs']['video']['width'] = '-';
        }
        if( !isset($stream_info['codecs']['video']['height']) ) 
        {
            $stream_info['codecs']['video']['height'] = '-';
        }
        $wh = $stream_info['codecs']['video']['width'] . ' X ' . $stream_info['codecs']['video']['height'];
        $codec = ($bitrate != '' ? '<div>' . $bitrate . ' K</div>' : '');
        $codec .= ('<div style=\'color:#888;\' title="' . $wh . '">' . $stream_info['codecs']['video']['codec_name'] . '/' . $stream_info['codecs']['audio']['codec_name'] . '</div>');
        if( $stream_status == 0 ) 
        {
            $txt_status = '<icon class="icon-globe" style=\'color:green;\'></icon>';
            $elapsed_time = ($stream_started != '' ? _obf_0D10361F073B102D294032060E21400727331210083132($stream_started) : '-');
        }
        else if( $stream_status == 1 && $on_demand == 0 ) 
        {
            $txt_status = '<icon class="icon-cancel-circled" style=\'color:#d90000;\'></icon>';
        }
        else
        {
            $txt_status = '<icon class="icon-globe" style=\'color:#a8a8b7;\'></icon>';
        }
        if( $on_demand == 1 ) 
        {
            $txt_status = '<icon class="icon-globe" style=\'color:#ff8000;\'></icon>';
        }
        if( $on_demand == 1 && $stream_status == 0 ) 
        {
            $txt_status = '<icon class="icon-globe" style=\'color:#86b300;\'></icon>';
        }
        $sql2 = $intro->db->query('SELECT id,value from streams_options where argument_id=1 AND stream_id=' . $id . ';');
        $row2 = $intro->db->fetch_assoc($sql2);
        $streams_options_value = trim($row2['value']);
        $streams_options_id = intval($row2['id']);
        $edit_page = 'streams';
        if( $this->type == 3 ) 
        {
            $edit_page = 'streams_created';
        }
        echo "\n\t\t\t<tr id='ChannelDataRow" . $id . "'>\n\t\t\t\t<td class=\"center\">" . $i . "</td>\n\t\t\t\t<td class=\"center\">" . $txt_status . " \n\t\t\t\t\t" . (($enable_transcode == 1 && $type == 1 ? '<i class="icon-thermometer red" title="Transcode On"></i>' : '')) . "\n\t\t\t\t\t" . ((intval($tv_archive_duration) != 0 && $type == 1 ? '<i class="icon-hdd red" title="TV Archive for (' . $tv_archive_duration . ') Days(s) "></i>' : '')) . ("\n\t\t\t\t\t</td>\n\t\t\t\t<td class=\"center dragHandle\">" . $id . "</td>\n\t\t\t\t<td id='StrmName_" . $id . '\'>' . $stream_display_name . "\n\t\t\t\t<a href=\"") . $intro->app_url('streams', 'Play') . ('/?NH=1&id=' . $id . "\" target=\"_blank\" title=\"Play stream using user in Tools->Codes Options\" class=\"XAjaxModal btn btn-default btn-xs icon-play-circled\" style='float:right;'></a>\n\t\t\t\t</td>\n\t\t\t\t<td class=\"center\"><img src=\"" . $stream_icon . "\" style=\"max-height:30px;\" alt=\"\" /></td>\n\t\t\t\t<td class=\"center\" id='elapsed_time_" . $id . '\'>' . $elapsed_time . "</td>\n\t\t\t\t<td class=\"center\">") . ((isset($array['servers'][$server_id]) ? $array['servers'][$server_id] : '-')) . ("\n\t\t\t\t<div style='font-size:8px;'>Pid:" . $pid . ' MPid:' . $monitor_pid . "</div>\n\t\t\t\t</td>\n\t\t\t\t<td class=\"center\" id='cur_host_" . $id . "'>\n\t\t\t\t\t") . ((isset($cur_host['host']) ? $this->getCurSourceNum($stream_source, $current_source) . ' ' . $cur_host['host'] : '')) . ("\n\t\t\t\t\t<div style='font-size:8px;'>" . $streams_options_value . "</div>\n\t\t\t\t</td>\n\t\t\t\t<td class=\"center\">");
        if( $tot > 0 ) 
        {
            echo '<a title=\'total online users | Send message or Fingerprint\' class=\'AjaxModal icon-address-card-o\' href="' . $intro->app_url('streams', 'FingerPrint') . '?id=' . $id . '"> ' . $tot . '</a>';
        }
        else
        {
            echo '-';
        }
        echo "</td>\n\t\t\t\t<td class=\"center\" id='live_" . $id . '\'>' . (($on_demand == 1 ? 'OnDemand' : 'Live')) . ("</td>\n\t\t\t\t<td class=\"center\">" . $codec . "</td>\n\t\t\t\t<td>");
        if( $this->seen_id != $id ) 
        {
            echo '<a href="' . $this->base . '/EditChannel?NH=1&id=' . $id . '" data-id="' . $id . "\" class=\"btn btn-warning btn-xs icon-code EditStreamRow\"></a>\n\t\t\t\t\t<a href=\"" . $intro->app_url($edit_page, 'Form') . ('?t=edit&id=' . $id . '" data-id="' . $id . '" class="btn btn-success btn-xs icon-edit"></a>');
            echo '<a href="' . $this->base . '/getStreamStatus?NH=1&id=' . $id . '" title="Refresh Status and uptime" data-id="' . $id . "\" class=\"btn btn-default btn-xs icon-arrows-cw GetStreamStatus\"></a>\n\t\t\t\t\t<a href=\"" . $this->base . '/Stop?NH=1&id=' . $id . '" title="Stop Stream" data-id="' . $id . "\" class=\"btn btn-default btn-xs icon-stop RestartStream\"></a>\n\t\t\t\t\t<a href=\"" . $this->base . '/Start?NH=1&id=' . $id . '" title="Start Stream" data-id="' . $id . "\" class=\"btn btn-default btn-xs icon-play RestartStream\"></a>\n\t\t\t\t\t";
            if( $sess_admin['level'] == 1 || $sess_admin['level'] == 8 ) 
            {
                echo '<a class="btn btn-danger btn-xs p_del intro_ui_del" href="' . $this->base . '/Del?id=' . $id . "\" onclick=\"return false;\" title=\"Delete\">\n\t\t\t\t\t\t<i class=\"icon-trash\"></i></a>";
            }
        }
        echo "\n\t\t\t\t</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td colspan=\"10\" id='chRow" . $id . "'></td>\n\t\t\t</tr>";
        $this->seen_id = $id;
    }
    public function JavaScript()
    {
        global $intro;
        global $array;
        $add_type = intval($intro->input->get_post('add_type'));
        echo "\n\t\t<div class=\"alert alert-success\" style=\"display:none;\">\n                <span class=\"glyphicon glyphicon-ok\"></span> Drag row to change Order</div>\n\t\t<script>\n\t\t\n\t\tvar spin = \"<span class='icon-spin5 animate-spin'></span>\";\n\t\t\n\t\tfunction tblHTML(number){\n\n\t\t\treturn '<tr>'\n\t\t\t+'<td>'+number+'</td>'\n\t\t\t+'<td><input type=\"text\" name=\"stream_source[]\" value=\"\" class=\"form-control\"></td>'\n\t\t\t+'<td><button type=\"button\" class=\"btn btn-danger btnDelStreamRow\"><span class=\"icon-trash\"></span></button></td>'\n\t\t\t+'</tr>';\n\t\t}\n\t\t\$(document).on('click', '.RestartStreamSingle', function(e){\n            e.preventDefault();\n\t\t\t\n\t\t\tvar id = \$(this).data('id');\n\t\t\tvar url = \$(this).attr('href');\n\t\t\tvar resultDiv = \$(\"#span_single_status\");\n\t\t\t\n\t\t\tresultDiv.html(spin);\n\t\t\t\$.get( url + \"&_dd=\" + \$.now(), function( data ) {\n\t\t\t\tresultDiv.html(data);\n\t\t\t});\n        });\n\t\t\$(document).on('click', '.RestartStream', function(e){\n            e.preventDefault();\n\t\t\t\n\t\t\tvar id = \$(this).data('id');\n\t\t\tvar url = \$(this).attr('href');\n\t\t\tvar resultDiv = \$(\"#live_\" + id);\n\t\t\t\n\t\t\tresultDiv.html(spin);\n\t\t\t\$.get( url + \"&_dd=\" + \$.now(), function( data ) {\n\t\t\t\tresultDiv.html(data);\n\t\t\t});\n        });\n\t\t\$(document).on('click', '.GetStreamStatus', function(e){\n            e.preventDefault();\n\t\t\t\n\t\t\tvar id = \$(this).data('id');\n\t\t\tvar url = \$(this).attr('href');\n\t\t\tvar allDivZ = \$(\"#live_\" + id +\",#elapsed_time_\" + id+\",#cur_host_\" + id);\n\n\t\t\t\n\t\t\tallDivZ.html(spin);\n\t\t\n\t\t\t\$.get( url+ \"&_dd=\" + \$.now(), function( data ) {\n\t\t\t\t\n\t\t\t\t\$.each(data, function(key, value) {\n\t\t\t\t\t  \$(\"#\"+key).html(value);\n\t\t\t\t});\n\t\t\t});\n\n        });\n\t\t\n\t\t\$(document).on('click', '.EditStreamRow', function(e){\n            e.preventDefault();\n\t\t\t\n\t\t\tvar id = \$(this).data('id');\n\t\t\tvar url = \$(this).attr('href');\n\t\t\tvar resultDiv = \$(\"#chRow\" + id);\n\t\t\t\n\t\t\tresultDiv.html(spin);\n\t\t\t\$.get( url + \"&_dd=\" + \$.now(), function( data ) {\n\t\t\t\t\n\t\t\t\tresultDiv.html(data);\n\t\t\t});\n\t\n        });\n\t\t\n\t\t\$(document).on('click', '.btnAddNewStreamRowFirst', function(e){\n\t\t\t\n\t\t\tvar table = \$(\"#tblStream\"+\$(this).data('id'));\n\t\t\t\n\t\t\tvar rowCount = \$('#tblStream'+\$(this).data('id')+' >tbody >tr').length;\n\t\t\t\n\t\t\ttable.prepend(tblHTML(0));\n\t\t\t\n\t\t});\n\t\t\$(document).on('click', '.btnAddNewStreamRowLast', function(e){\n\t\t\t\n\t\t\tvar table = \$(\"#tblStream\"+\$(this).data('id'));\n\t\t\t\n\t\t\tvar rowCount = \$('#tblStream'+\$(this).data('id')+' >tbody >tr').length;\n\t\t\t\n\t\t\ttable.append(tblHTML(rowCount));\n\t\t\t\n\t\t});\n\t\t\n\t\t\$(document).on('click', '.btnCloseFrmChEdit', function(e){\n\t\t\t\$(\"#\"+\$(this).data('id')).html('');\n\t\t});\n\t\t\n\t\t\$(document).on('click', '.btnDelStreamRow', function(e){\n\t\t\t\n\t\t\tif( confirm(\"Delete this Stream Source?\") )\n\t\t\t{\n\t\t\t\t\$(this).closest(\"tr\").remove();\n\t\t\t}\n\t\t\t\n\t\t});\n\t\t\$(document).on('change', '#singleMulti', function(e){\n\t\t\t\n\t\t\tvar t = \$(this).val();\n\t\t\t\n\t\t\tshow_hide_add_stream(t);\n\t\t\t\n\t\t});\n\t\tfunction show_hide_add_stream(t){\n\t\t\tif(t == 1){\n\t\t\t\t\$('.singleTR').show();\n\t\t\t\t\$('#upload_m3u').hide();\n\t\t\t}else{\n\t\t\t\t\$('.singleTR').hide();\n\t\t\t\t\$('#upload_m3u').show();\n\t\t\t}\n\t\t}\n\t\t\$(document).on(\"submit\", \".frmSaveStream\", function (e) {\n\t\t\t/*\n\t\t\t\$(\".frmSaveStream :input\").each(function(){\n\t\t\t\tvar input = \$(this);\n\t\t\t\tvar str = input.val();\n\t\t\t\tinput.val(str.replace(/\\//g, '|'))\n\t\t\t});\n\t\t\t//str.replace(/\\//g, replacement);\n\t\t\t*/\n\t\t\t\n\t\t\t\n\t\t\tvar chID = \$(this).data('id');\n\t\n\t\t\tvar chName = \$(\"#stream_name_\" + chID).val();\n\t\t\tif(chName != \"\"){\n\t\t\t\t\$(\"#StrmName_\" + chID).html(chName);\n\t\t\t}\n\t\t\tvar spnResult = \$(\"#frmSpanResult\" + chID);\n\t\t\tspnResult.html(spin);\n\t\t\tvar jqxhr = \$.post( \$(this).attr('action') ,\$(this).serialize(),\n\t\t\t\tfunction(data){\n\t\t\t\t\tspnResult.html(data);\n\t\t\t\t\t/*\$(this).style(\"background-color: #5cb85c;border-color: #4cae4c;\");*/\n\t\t\t\t\t\$(\"#ChannelDataRow\" + chID).css(\"background-color\", \"#5cb85c\");\n\t\t\t\t}\n\t\t\t).fail(function() {\n\t\t\t\t\n\t\t\t\talert( \"error. faild to POST\" );\n\t\t\t\tspnResult.html('');\n\t\t\t});\n\t\t\treturn false;\n\t\t});\n\t\t" . (($add_type > 0 ? 'show_hide_add_stream(' . $add_type . ')' : '')) . "\n\t\t</script>";
    }
    public function EditChannel()
    {
        global $intro;
        global $array;
        $qry = '';
        $id = intval($intro->input->get_post('id'));
        $sql = $intro->db->query('SELECT * from streams where id=' . $id);
        $row = $intro->db->fetch_assoc($sql);
        $stream_source = trim($row['stream_source']);
        $stream_icon = trim($row['stream_icon']);
        $stream_display_name = $row['stream_display_name'];
        $stream_source = json_decode($stream_source, true);
        $sql2 = $intro->db->query('SELECT id,value from streams_options where argument_id=1 AND stream_id=' . $id);
        $row2 = $intro->db->fetch_assoc($sql2);
        $streams_options_value = trim($row2['value']);
        $streams_options_id = intval($row2['id']);
        echo "\n\t\t<fieldset>\n\t\t<form action=\"" . $this->base . '/doEditChannel?NH=1" data-id="' . $id . "\" class=\"frmSaveStream\" method=\"post\">\n\t\t\t\n\t\t\t<input name=\"streams_options_id\" value=\"" . $streams_options_id . "\" type=\"hidden\">\n\t\t\t\n\t\t\t<table class='table table=striped table-condensed' id=\"tblStream" . $id . "\">\n\t\t\t<thead>\n\t\t\t<tr>\n\t\t\t\t<td style='width:70px'>Name:</td>\n\t\t\t\t<td><input type=\"text\" name=\"stream_display_name\" id=\"stream_name_" . $id . '" value="' . $stream_display_name . "\" class='form-control danger' style='background-color:#ffff4c;color:#000' placeholder='Stream Name' required=''></td>\n\t\t\t\t<td></td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td>Logo:</td>\n\t\t\t\t<td><input type=\"text\" name=\"stream_icon\" value=\"" . $stream_icon . "\" class='form-control danger' style='background-color:#ffffbf;;color:#000' placeholder='Stream Icon'></td>\n\t\t\t\t<td><img src=\"" . $stream_icon . "\" style=\"max-height:60px;\" alt=\"\" /></td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td>UserAgent:</td>\n\t\t\t\t<td><input type=\"text\" name=\"streams_options_value\" value=\"" . $streams_options_value . "\" class='form-control danger' style='background-color:#dfffbf;color:#000' placeholder='Useragent'></td>\n\t\t\t\t<td></td>\n\t\t\t</tr>\n\t\t\t</thead>\n\t\t\t<tbody>";
        $i = 0;
        foreach( $stream_source as $val ) 
        {
            $i++;
            echo "\n\t\t\t\t<tr>\n\t\t\t\t\t<td>" . $i . "</td>\n\t\t\t\t\t<td><input type=\"text\" name=\"stream_source[]\" value=\"" . $val . "\" class='form-control'></td>\n\t\t\t\t\t<td><button type=\"button\" class='btn btn-danger btnDelStreamRow'><span class='icon-trash'></span></button></td>\n\t\t\t\t</tr>";
        }
        echo "\n\t\t\t\t</tbody>\n\t\t\t\t<tfooter>\n\t\t\t\t<tr>\n\t\t\t\t\t<td></td>\n\t\t\t\t\t<td><label class=\"checkbox-inline\"><input type=\"checkbox\" name=\"restart\" value=\"1\">Restart Stream?</label></td>\n\t\t\t\t</tr>\n\t\t\t\t<tr>\n\t\t\t\t\t<td></td>\n\t\t\t\t\t<td>\n\t\t\t\t\t\t<input name=\"chID\" value=\"" . $id . "\" type=\"hidden\">\n\t\t\t\t\t\t<button type=\"submit\" class='btn btn-success'><span class='icon-floppy'></span>Save</button>\n\t\t\t\t\t\t<button data-id=\"" . $id . "\" type=\"button\" class='btn btn-default btnAddNewStreamRowFirst'><span class='icon-plus-squared'></span>First</button>\n\t\t\t\t\t\t<button data-id=\"" . $id . "\" type=\"button\" class='btn btn-default btnAddNewStreamRowLast'><span class='icon-plus-squared'></span>Last</button>\n\t\t\t\t\t\t<button data-id=\"chRow" . $id . "\" type=\"button\" class='btn btn-default btnCloseFrmChEdit'><span class='icon-cancel-circled'></span>Close</button>\n\t\t\t\t\t\t<span id=\"frmSpanResult" . $id . "\"></span>\n\t\t\t\t\t</td>\n\t\t\t\t</tr>\n\t\t\t\t</tfooter>\n\t\t\t</table>\n\t\t\t\n\t\t\t\n\t\t\t\n\t\t</form>\n\t\t<!--\n\t\t<input id='urlOfStremCPY' type=\"text\" value=\"/" . $id . ".ts\" size=50>\n\t\t\t<button id='copy_btn'>Copy</button>\n\t\t\t-->\n\t\t</fieldset>";
        echo "<script>\n\t\tfunction clickListener() {\n\t\t  document.getElementById('urlOfStremCPY').select();\n\t\t  document.execCommand('copy');\n\t\t}\n\t\tdocument.getElementById('copy_btn').addEventListener('click', clickListener);\n\t\t</script>";
    }
    public function doEditChannel()
    {
        global $intro;
        global $array;
        $affected_rows = 0;
        $chID = intval($intro->input->post('chID'));
        $stream_source = $intro->input->post('stream_source');
        $stream_display_name = trim($intro->input->post('stream_display_name'));
        $stream_icon = trim($intro->input->post('stream_icon'));
        $streams_options_id = intval($intro->input->post('streams_options_id'));
        $streams_options_value = trim($intro->input->post('streams_options_value'));
        $error = '<span class=\'label label-danger\'>Error: nothing to save!!!.</span>';
        $error2 = '<span class=\'label label-danger\'>Error: Stream Name is Empty!!!.</span>';
        if( !isset($stream_source[0]) ) 
        {
            exit( ' ' . $error );
        }
        if( $stream_display_name == '' ) 
        {
            exit( ' ' . $error2 );
        }
        if( $streams_options_id == 0 && $streams_options_value != '' ) 
        {
            $data = [];
            $data['argument_id'] = 1;
            $data['stream_id'] = $chID;
            $data['value'] = $streams_options_value;
            $intro->db->insert('streams_options', $data);
            $affected_rows = $intro->db->affected_rows;
        }
        else if( $streams_options_id > 0 && $streams_options_value != '' ) 
        {
            $intro->db->update('streams_options', ['value' => $streams_options_value], 'id=' . $streams_options_id);
            $affected_rows = $intro->db->affected_rows;
        }
        else if( $streams_options_value == '' ) 
        {
            $intro->db->query('DELETE FROM streams_options WHERE argument_id=1 AND stream_id=' . $chID);
            $affected_rows = $intro->db->affected_rows;
        }
        $source = array_map('trim', $stream_source);
        $source = array_filter($source);
        if( is_array($source) ) 
        {
            $data = [];
            $data['stream_source'] = json_encode($source);
            $data['stream_display_name'] = $stream_display_name;
            $data['stream_icon'] = $stream_icon;
            $intro->db->update('streams', $data, 'id=' . $chID);
            if( $intro->db->affected_rows > 0 ) 
            {
                $affected_rows = $intro->db->affected_rows;
            }
        }
        if( $affected_rows > 0 ) 
        {
            echo '<span class=\'label label-success\'>Update Success!</span>';
        }
        else
        {
            echo '<span class=\'label label-warning\'>Nothing has changed.</span>';
        }
        if( intval($intro->input->post('restart')) == 1 ) 
        {
            $x = new XtreamApi('EmptyFunc');
            $x->Restart($chID);
        }
    }
}
