<?php 

class Configuration
{
    private $apikey = "";
    private $lang = "en";
    private $timezone = "Europe/London";
    private $adult = false;
    private $debug = false;
    private $appender = NULL;

    public function __construct($cnf)
    {
        $cnf["appender"]["movie"] = [ "trailers", "images", "credits", "translations", "reviews", "release_dates" ];
        $cnf["appender"]["tvshow"] = [ "trailers", "images", "credits", "translations", "keywords" ];
        $cnf["appender"]["season"] = [ "trailers", "images", "credits", "translations" ];
        $cnf["appender"]["episode"] = [ "trailers", "images", "credits", "translations" ];
        $cnf["appender"]["person"] = [ "movie_credits", "tv_credits", "images" ];
        $cnf["appender"]["collection"] = [ "images" ];
        $cnf["appender"]["company"] = [ "movies" ];
        $cnf["adult"] = false;
        $cnf["debug"] = false;
        if( !isset($cnf) ) 
        {
            require_once(dirname(__FILE__) . "/../../../configuration/default.php");
        }

        $this->setAPIKey($cnf["apikey"]);
        $this->setLang($cnf["lang"]);
        $this->setTimeZone("timezone");
        $this->setAdult($cnf["adult"]);
        $this->setDebug($cnf["debug"]);
        foreach( $cnf["appender"] as $type => $appender ) 
        {
            $this->setAppender($appender, $type);
        }
    }

    public function setAPIKey($apikey)
    {
        $this->apikey = $apikey;
    }

    public function setLang($lang)
    {
        $this->lang = $lang;
    }

    public function setTimeZone($timezone)
    {
        $this->timezone = $timezone;
    }

    public function setAdult($adult)
    {
        $this->adult = $adult;
    }

    public function setDebug($debug)
    {
        $this->debug = $debug;
    }

    public function setAppender($appender, $type)
    {
        $this->appender[$type] = $appender;
    }

    public function getAPIKey()
    {
        return $this->apikey;
    }

    public function getLang()
    {
        return $this->lang;
    }

    public function getTimeZone()
    {
        return $this->timezone;
    }

    public function getAdult()
    {
        return ($this->adult ? "true" : "false");
    }

    public function getDebug()
    {
        return $this->debug;
    }

    public function getAppender($type)
    {
        return $this->appender[$type];
    }

}


