<?php 

class TVShow extends ApiBaseObject
{
    public function getName()
    {
        return $this->_data["name"];
    }

    public function getOriginalName()
    {
        return $this->_data["original_name"];
    }

    public function getNumSeasons()
    {
        return $this->_data["number_of_seasons"];
    }

    public function getNumEpisodes()
    {
        return $this->_data["number_of_episodes"];
    }

    public function getSeason($numSeason)
    {
        $data = NULL;
        foreach( $this->_data["seasons"] as $season ) 
        {
            if( $season["season_number"] == $numSeason ) 
            {
                $data = $season;
                return new Season($data);
            }

        }
    }

    public function getSeasons()
    {
        $seasons = [  ];
        foreach( $this->_data["seasons"] as $data ) 
        {
            $seasons[] = new Season($data, $this->getID());
        }
        return $seasons;
    }

    public function getBackdrop()
    {
        return $this->_data["backdrop_path"];
    }

    public function getOverview()
    {
        return $this->_data["overview"];
    }

    public function getInProduction()
    {
        return $this->_data["in_production"];
    }

    public function getJSON()
    {
        return json_encode($this->_data, JSON_PRETTY_PRINT);
    }

    public function getMediaType()
    {
        return MEDIA_TYPE_TV;
    }

}


