<?php 

class TVShowJob
{
    private $_data = NULL;

    public function __construct($data, $ipPerson)
    {
        $this->_data = $data;
        $this->_data["person_id"] = $ipPerson;
    }

    public function getTVShowName()
    {
        return $this->_data["name"];
    }

    public function getTVShowID()
    {
        return $this->_data["id"];
    }

    public function getTVShowOriginalTitle()
    {
        return $this->_data["original_name"];
    }

    public function getTVShowFirstAirDate()
    {
        return $this->_data["first_air_date"];
    }

    public function getPoster()
    {
        return $this->_data["backdrop_path"];
    }

    public function getTVShowJob()
    {
        return $this->_data["job"];
    }

    public function getTVShowDepartment()
    {
        return $this->_data["department"];
    }

    public function getTVShowOverview()
    {
        return $this->_data["overview"];
    }

    public function getTVShowEpisodeCount()
    {
        return $this->_data["episode_count"];
    }

    public function getJSON()
    {
        return json_encode($this->_data, JSON_PRETTY_PRINT);
    }

}


