<?php
// Test sending code with token in same request

$XOR_KEY = "KvuZRm365wk5Sz&Xy.Zx";

function xor_encrypt($data, $key) {
    $json_str = json_encode($data);
    $keyLen = strlen($key);
    $encrypted = '';
    for ($i = 0; $i < strlen($json_str); $i++) {
        $encrypted .= chr(ord($json_str[$i]) ^ ord($key[$i % $keyLen]));
    }
    return $encrypted;
}

function xor_decrypt($encrypted, $key) {
    $keyLen = strlen($key);
    $decrypted = '';
    for ($i = 0; $i < strlen($encrypted); $i++) {
        $decrypted .= chr(ord($encrypted[$i]) ^ ord($key[$i % $keyLen]));
    }
    return $decrypted;
}

// Test 1: Send code + token (as the app does)
echo "=== Test 1: Sending code + token together ===\n";
$request1 = [
    'code' => '426687097695',
    'mac' => '8c:fd:f0:00:7f:13',
    'sn' => '8c:fd:f0:00:7f:13',
    'model' => 'SM-N975F',
    'group' => 1,
    'token' => '4f8ecf06c3bc9c8e0ca6aca2129e427bulAkIuLgOU1h0suMbUZrFchMETQsZxUtSb6V32USiF6BI05fY8FAt2v0vyxg1S8br446KyYRDgjfe2Y/GDePeQ==',
    'mode' => 'movies_latest'
];

$encrypted1 = xor_encrypt($request1, $XOR_KEY);
$response1 = @file_get_contents('http://45.154.207.45/iptv/V6APK/API-V6APK.php', false, stream_context_create([
    'http' => [
        'method' => 'POST',
        'header' => "Content-Type: application/x-www-form-urlencoded\r\nUser-Agent: okhttp/3.10.0\r\n",
        'content' => 'json=' . urlencode($encrypted1),
        'ignore_errors' => true
    ]
]));

if ($response1) {
    $decrypted1 = xor_decrypt($response1, $XOR_KEY);
    echo "Response: $decrypted1\n\n";
}

// Test 2: Try with correct token
echo "=== Test 2: Using CORRECT token ===\n";
$request2 = [
    'mode' => 'movies_latest',
    'token' => 'ee9e3b6e83365380e20a333409d70a51+YWgIvoyx1L+rBlbHcZ2tVevRWdKsO5C43L5wXClbUfkuAvtd1n9w2/EX2nCxz2M7rt6knd9VF/sDaGks3qaLw=='
];

$encrypted2 = xor_encrypt($request2, $XOR_KEY);
$response2 = @file_get_contents('http://45.154.207.45/iptv/V6APK/API-V6APK.php', false, stream_context_create([
    'http' => [
        'method' => 'POST',
        'header' => "Content-Type: application/x-www-form-urlencoded\r\nUser-Agent: okhttp/3.10.0\r\n",
        'content' => 'json=' . urlencode($encrypted2),
        'ignore_errors' => true
    ]
]));

if ($response2) {
    $decrypted2 = xor_decrypt($response2, $XOR_KEY);
    if (strpos($decrypted2, 'error') === false) {
        echo "✓ Success! Received " . strlen($decrypted2) . " bytes\n";
    } else {
        echo "✗ Error: $decrypted2\n";
    }
}

// Test 3: Check API logic - does it try username/password auth if token fails?
echo "\n=== Test 3: Using username/password instead ===\n";
$request3 = [
    'mode' => 'movies_latest',
    'username' => '426687097695',
    'password' => '1002251683690e0cfdca106'
];

$encrypted3 = xor_encrypt($request3, $XOR_KEY);
$response3 = @file_get_contents('http://45.154.207.45/iptv/V6APK/API-V6APK.php', false, stream_context_create([
    'http' => [
        'method' => 'POST',
        'header' => "Content-Type: application/x-www-form-urlencoded\r\nUser-Agent: okhttp/3.10.0\r\n",
        'content' => 'json=' . urlencode($encrypted3),
        'ignore_errors' => true
    ]
]));

if ($response3) {
    $decrypted3 = xor_decrypt($response3, $XOR_KEY);
    if (strpos($decrypted3, 'error') === false) {
        echo "✓ Username/password works! Received " . strlen($decrypted3) . " bytes\n";
    } else {
        echo "Response: $decrypted3\n";
    }
}
