<?php
/**
 * Quick Token Tester
 * Usage: php test_token.php "your_token_here"
 */

$XOR_KEY = "KvuZRm365wk5Sz&Xy.Zx";

function xor_encrypt($data, $key) {
    $json_str = json_encode($data);
    $keyLen = strlen($key);
    $encrypted = '';
    for ($i = 0; $i < strlen($json_str); $i++) {
        $encrypted .= chr(ord($json_str[$i]) ^ ord($key[$i % $keyLen]));
    }
    return $encrypted;
}

function xor_decrypt($encrypted, $key) {
    $keyLen = strlen($key);
    $decrypted = '';
    for ($i = 0; $i < strlen($encrypted); $i++) {
        $decrypted .= chr(ord($encrypted[$i]) ^ ord($key[$i % $keyLen]));
    }
    return $decrypted;
}

// Get token from command line
if ($argc < 2) {
    echo "Usage: php test_token.php \"your_token_here\"\n";
    echo "\nExample:\n";
    echo "php test_token.php \"f3ed71d56579442cbdc114e8f77e57b4rueo5uPmlFslxvKta6...\"\n";
    exit(1);
}

$token = $argv[1];

echo "Testing Token\n";
echo str_repeat("=", 72) . "\n";
echo "Token: " . substr($token, 0, 50) . "...\n";
echo "Length: " . strlen($token) . " chars\n\n";

// Test with API
$request = [
    'mode' => 'packages',
    'token' => $token
];

$encrypted = xor_encrypt($request, $XOR_KEY);
$response = @file_get_contents('http://45.154.207.45/iptv/V6APK/API-V6APK.php', false, stream_context_create([
    'http' => [
        'method' => 'POST',
        'header' => "Content-Type: application/x-www-form-urlencoded\r\nUser-Agent: okhttp/3.10.0\r\n",
        'content' => 'json=' . urlencode($encrypted),
        'ignore_errors' => true,
        'timeout' => 10
    ]
]));

if ($response) {
    $decrypted = xor_decrypt($response, $XOR_KEY);

    if (strpos($decrypted, 'error') === false) {
        echo "✅ SUCCESS! Token is valid and working.\n";
        $data = json_decode($decrypted, true);
        if (is_array($data)) {
            echo "   Response: " . count($data) . " items returned\n";
        }
    } else {
        echo "❌ FAILED! Server response: $decrypted\n";
    }
} else {
    echo "❌ No response from server\n";
}

// Check database
require_once('/var/www/html/iptv/includes/Config.php');
$link = mysqli_connect(
    $config['db']['hostname'],
    $config['db']['username'],
    $config['db']['password'],
    $config['db']['database']
);

if ($link) {
    $safe_token = mysqli_real_escape_string($link, $token);
    $result = mysqli_query($link, "
        SELECT t.user_id, u.username, FROM_UNIXTIME(t.created) as created,
               FROM_UNIXTIME(t.expires) as expires, (t.expires > UNIX_TIMESTAMP()) as is_valid
        FROM user_tokens t
        JOIN users u ON t.user_id = u.id
        WHERE t.token = '$safe_token'
    ");

    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        echo "\n📝 Database Info:\n";
        echo "   User: " . $row['username'] . " (ID: " . $row['user_id'] . ")\n";
        echo "   Created: " . $row['created'] . "\n";
        echo "   Expires: " . $row['expires'] . "\n";
        echo "   Status: " . ($row['is_valid'] ? '✅ Valid' : '❌ Expired') . "\n";
    } else {
        echo "\n❌ Token not found in database\n";
    }

    mysqli_close($link);
}

echo "\n" . str_repeat("=", 72) . "\n";
