<?php
/**
 * XMLTV EPG Proxy
 * Accepts ANY username/password from client
 * Returns same EPG for all (channels are same for everyone)
 *
 * Usage: xmltv.php?username=ANY&password=ANY
 */

header('Content-Type: application/xml; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Cache-Control: public, max-age=1800');

// Cache file
$cache_file = __DIR__ . '/cache/epg.xml';
$cache_time = 1800; // 30 minutes

// Serve from cache if valid
if (file_exists($cache_file) && (time() - filemtime($cache_file)) < $cache_time) {
    readfile($cache_file);
    exit;
}

// Load config
require_once __DIR__ . '/includes/Config.php';

try {
    $pdo = new PDO(
        "mysql:host={$config['db']['hostname']};dbname={$config['db']['database']};charset=utf8",
        $config['db']['username'],
        $config['db']['password']
    );

    // Get source credentials from panel_settings
    $stmt = $pdo->query("SELECT setting_key, setting_value FROM panel_settings");
    $settings = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $settings[$row['setting_key']] = $row['setting_value'];
    }

    $panel_url = $settings['panel_url'] ?? '';
    $source_user = $settings['panel_username'] ?? '';
    $source_pass = $settings['panel_password'] ?? '';

    // Get EPG from source using MASTER credentials
    $parsed = parse_url($panel_url);
    $epg_url = 'http://' . $parsed['host'] . ':80/xmltv.php?username=' . urlencode($source_user) . '&password=' . urlencode($source_pass);

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $epg_url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 120,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_FOLLOWLOCATION => true
    ]);

    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($http_code == 200 && $response) {
        // Cache it
        @mkdir(__DIR__ . '/cache', 0755, true);
        file_put_contents($cache_file, $response);
        echo $response;
    } elseif (file_exists($cache_file)) {
        readfile($cache_file);
    } else {
        echo '<?xml version="1.0" encoding="utf-8"?><tv></tv>';
    }

} catch (Exception $e) {
    if (file_exists($cache_file)) {
        readfile($cache_file);
    } else {
        echo '<?xml version="1.0" encoding="utf-8"?><tv></tv>';
    }
}
?>
